/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.PreferenceScopeTypes;
import org.uberfire.preferences.shared.UsernameProvider;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeTypes;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopesForTests;
import org.uberfire.preferences.shared.impl.DefaultScopes;
import org.uberfire.preferences.shared.impl.PreferenceScopeFactoryImpl;
import org.uberfire.preferences.shared.impl.PreferenceScopeImpl;
import org.uberfire.preferences.shared.impl.PreferenceScopeValidatorImpl;
import org.uberfire.preferences.shared.impl.UsernameProviderMock;
import org.uberfire.preferences.shared.impl.exception.InvalidPreferenceScopeException;
import org.uberfire.rpc.SessionInfo;

public class PreferenceScopeValidatorImplTest {
    private PreferenceScopeValidatorImpl validator;

    @Before
    public void setup() {
        SessionInfoMock sessionInfo = new SessionInfoMock("my-user");
        DefaultPreferenceScopeTypes scopeTypes = new DefaultPreferenceScopeTypes((UsernameProvider)new UsernameProviderMock((SessionInfo)sessionInfo));
        PreferenceScopeFactoryImpl scopeFactory = new PreferenceScopeFactoryImpl((PreferenceScopeTypes)scopeTypes);
        DefaultPreferenceScopeResolutionStrategy scopeResolutionStrategy = new DefaultPreferenceScopeResolutionStrategy((PreferenceScopeFactory)scopeFactory, null);
        this.validator = new PreferenceScopeValidatorImpl((PreferenceScopeTypes)scopeTypes, (PreferenceScopeResolutionStrategy)scopeResolutionStrategy);
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void validateNullScopeTest() {
        this.validator.validate(null);
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void validateScopeWithInvalidTypeTest() {
        this.validator.validate((PreferenceScope)new PreferenceScopeImpl("invalidType", null, null));
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void validateScopeWithTypeThatRequiresKeyWithoutKeyTest() {
        this.validator.validate((PreferenceScope)new PreferenceScopeImpl(DefaultScopes.COMPONENT.type(), null, null));
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void validateScopeWithValidScopeButNotInTheOrderTest() {
        this.validator.validate((PreferenceScope)new PreferenceScopeImpl(DefaultScopes.USER.type(), null, null));
    }

    @Test
    public void validateValidScopeTest() {
        this.validator.validate((PreferenceScope)DefaultPreferenceScopesForTests.userEntireApplicationScope);
    }

    @Test
    public void isEmptyTest() {
        Assert.assertTrue((boolean)this.validator.isEmpty(null));
        Assert.assertTrue((boolean)this.validator.isEmpty(""));
        Assert.assertTrue((boolean)this.validator.isEmpty("  "));
        Assert.assertFalse((boolean)this.validator.isEmpty("anyString"));
    }
}

