/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.backend;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.annotations.Customizable;
import org.uberfire.ext.preferences.shared.PreferenceScope;
import org.uberfire.ext.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.ext.preferences.shared.PreferenceStore;
import org.uberfire.ext.preferences.shared.annotations.PortablePreference;
import org.uberfire.ext.preferences.shared.annotations.Property;
import org.uberfire.ext.preferences.shared.annotations.RootPreference;
import org.uberfire.ext.preferences.shared.annotations.WorkbenchPreference;
import org.uberfire.ext.preferences.shared.bean.BasePreference;
import org.uberfire.ext.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.ext.preferences.shared.bean.Preference;
import org.uberfire.ext.preferences.shared.bean.PreferenceBeanServerStore;
import org.uberfire.ext.preferences.shared.bean.PreferenceHierarchyElement;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Service
public class PreferenceBeanStoreImpl
implements PreferenceBeanServerStore {
    private static final AnnotationLiteral<PortablePreference> portablePreferenceAnnotation = new AnnotationLiteral<PortablePreference>(){};
    private static final AnnotationLiteral<RootPreference> rootPreferenceAnnotation = new AnnotationLiteral<RootPreference>(){};
    private PreferenceStore preferenceStore;
    private PreferenceScopeResolutionStrategy defaultScopeResolutionStrategy;
    private Instance<Preference> preferences;

    public PreferenceBeanStoreImpl() {
    }

    @Inject
    public PreferenceBeanStoreImpl(PreferenceStore preferenceStore, @Customizable PreferenceScopeResolutionStrategy defaultScopeResolutionStrategy, @PortablePreference Instance<Preference> preferences) {
        this.preferenceStore = preferenceStore;
        this.defaultScopeResolutionStrategy = defaultScopeResolutionStrategy;
        this.preferences = preferences;
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> T load(T emptyPortablePreference) {
        Class clazz = emptyPortablePreference.getPojoClass();
        BasePreferencePortable portablePreference = (BasePreferencePortable)this.preferenceStore.get(emptyPortablePreference.key());
        try {
            return (T)this.load(clazz, portablePreference);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void load(T emptyPortablePreference, ParameterizedCommand<T> successCallback, ParameterizedCommand<Throwable> errorCallback) {
        Object loadedPreference;
        block3: {
            loadedPreference = null;
            try {
                loadedPreference = this.load(emptyPortablePreference);
            }
            catch (Exception e) {
                if (errorCallback == null) break block3;
                errorCallback.execute((Object)e);
            }
        }
        if (successCallback != null) {
            successCallback.execute(loadedPreference);
        }
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void save(T portablePreference) {
        try {
            Class clazz = portablePreference.getPojoClass();
            this.save(clazz, portablePreference);
            this.preferenceStore.put(portablePreference.key(), portablePreference);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void save(T portablePreference, Command successCallback, ParameterizedCommand<Throwable> errorCallback) {
        block3: {
            try {
                this.save(portablePreference);
            }
            catch (Exception e) {
                if (errorCallback == null) break block3;
                errorCallback.execute((Object)e);
            }
        }
        if (successCallback != null) {
            successCallback.execute();
        }
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void saveDefaultValue(T defaultValue) {
        List scopeOrder = this.defaultScopeResolutionStrategy.getInfo().order();
        int lastIndex = scopeOrder.size() - 1;
        PreferenceScope lastScope = (PreferenceScope)scopeOrder.get(lastIndex);
        this.preferenceStore.put(lastScope, defaultValue.key(), defaultValue);
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void saveDefaultValue(T defaultValue, Command successCallback, ParameterizedCommand<Throwable> errorCallback) {
        block3: {
            try {
                this.saveDefaultValue(defaultValue);
            }
            catch (Exception e) {
                if (errorCallback == null) break block3;
                errorCallback.execute((Object)e);
            }
        }
        if (successCallback != null) {
            successCallback.execute();
        }
    }

    public void save(Collection<BasePreferencePortable<? extends BasePreference<?>>> portablePreferences) {
        for (BasePreferencePortable<BasePreference<?>> basePreferencePortable : portablePreferences) {
            this.saveOne(basePreferencePortable);
        }
    }

    public void save(Collection<BasePreferencePortable<? extends BasePreference<?>>> portablePreferences, Command successCallback, ParameterizedCommand<Throwable> errorCallback) {
        block3: {
            try {
                this.save(portablePreferences);
            }
            catch (Exception e) {
                if (errorCallback == null) break block3;
                errorCallback.execute((Object)e);
            }
        }
        if (successCallback != null) {
            successCallback.execute();
        }
    }

    public List<PreferenceHierarchyElement<?>> buildHierarchyStructure() {
        ArrayList hierarchyRoots = new ArrayList();
        this.getRootPortablePreferences().forEach(rootPreference -> {
            BasePreferencePortable preference = (BasePreferencePortable)rootPreference;
            preference = this.load(preference);
            PreferenceHierarchyElement childElement = this.buildHierarchyElement(preference, null, false, true, preference.bundleKey());
            hierarchyRoots.add(childElement);
        });
        return hierarchyRoots;
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> T load(Class<U> clazz, T portablePreference) throws IllegalAccessException {
        if (portablePreference == null) {
            portablePreference = this.lookupPortablePreference(clazz);
        }
        for (Field field : portablePreference.getPojoClass().getDeclaredFields()) {
            Property propertyAnnotation = field.getAnnotation(Property.class);
            if (propertyAnnotation == null || !field.getType().isAnnotationPresent(WorkbenchPreference.class)) continue;
            Class<?> propertyType = field.getType();
            boolean inherited = propertyAnnotation.inherited();
            field.setAccessible(true);
            if (inherited) {
                T loadedInheritedProperty = this.loadInheritedPreference(field);
                field.set(portablePreference, loadedInheritedProperty);
                continue;
            }
            T subPreferenceValue = this.loadSubPreferenceValue(portablePreference, field);
            field.set(portablePreference, subPreferenceValue);
        }
        return portablePreference;
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> T loadInheritedPreference(Field field) {
        BasePreferencePortable loadedPreference;
        Class<?> propertyType = field.getType();
        try {
            T emptyPortablePreference = this.lookupPortablePreference(propertyType);
            BasePreferencePortable portablePreference = (BasePreferencePortable)this.preferenceStore.get(emptyPortablePreference.key());
            loadedPreference = this.load(propertyType, portablePreference);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)loadedPreference;
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> T loadSubPreferenceValue(Object portablePreference, Field field) throws IllegalAccessException {
        Class<?> propertyType = field.getType();
        BasePreferencePortable subPreferenceValue = (BasePreferencePortable)field.get(portablePreference);
        return (T)this.load(propertyType, subPreferenceValue);
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void save(Class<U> clazz, T portablePreference) throws IllegalAccessException {
        for (Field field : portablePreference.getPojoClass().getDeclaredFields()) {
            Property propertyAnnotation = field.getAnnotation(Property.class);
            if (propertyAnnotation == null || !field.getType().isAnnotationPresent(WorkbenchPreference.class)) continue;
            boolean inherited = propertyAnnotation.inherited();
            field.setAccessible(true);
            if (inherited) {
                this.saveInheritedPreference(portablePreference, field);
                continue;
            }
            this.saveSubPreference(portablePreference, field);
        }
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void saveInheritedPreference(Object portablePreference, Field field) throws IllegalAccessException {
        Class<?> propertyType = field.getType();
        BasePreferencePortable inheritedPropertyValue = (BasePreferencePortable)field.get(portablePreference);
        this.save(inheritedPropertyValue, null, null);
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void saveSubPreference(Object portablePreference, Field field) throws IllegalAccessException {
        Class<?> propertyType = field.getType();
        BasePreferencePortable subPreferenceValue = (BasePreferencePortable)field.get(portablePreference);
        this.save(propertyType, subPreferenceValue);
    }

    private <T extends BasePreference<T>> void saveOne(BasePreferencePortable<?> portablePreference) {
        Class clazz = portablePreference.getPojoClass();
        try {
            this.save(clazz, portablePreference);
            this.preferenceStore.put(portablePreference.key(), portablePreference);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> PreferenceHierarchyElement<T> buildHierarchyElement(BasePreferencePortable<T> portablePreference, PreferenceHierarchyElement<?> parent, boolean inherited, boolean root, String bundleKey) {
        PreferenceHierarchyElement hierarchyElement = new PreferenceHierarchyElement(UUID.randomUUID().toString(), portablePreference, inherited, root, bundleKey);
        try {
            hierarchyElement.setPortablePreference(portablePreference);
            for (Field field : portablePreference.getPojoClass().getDeclaredFields()) {
                Property propertyAnnotation = field.getAnnotation(Property.class);
                if (propertyAnnotation == null) continue;
                String propertyBundleKey = "";
                if (!propertyAnnotation.bundleKey().isEmpty()) {
                    propertyBundleKey = propertyAnnotation.bundleKey();
                }
                if (field.getType().isAnnotationPresent(WorkbenchPreference.class)) {
                    field.setAccessible(true);
                    BasePreferencePortable fieldValue = (BasePreferencePortable)field.get(portablePreference);
                    if (propertyBundleKey.isEmpty()) {
                        propertyBundleKey = fieldValue.bundleKey();
                    }
                    PreferenceHierarchyElement<T> childElement = this.buildHierarchyElement(fieldValue, hierarchyElement, propertyAnnotation.inherited(), false, propertyBundleKey);
                    hierarchyElement.getChildren().add(childElement);
                    continue;
                }
                if (propertyBundleKey.isEmpty()) {
                    propertyBundleKey = field.getName();
                }
                hierarchyElement.addPropertyBundleKey(field.getName(), propertyBundleKey);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return hierarchyElement;
    }

    Iterable<Preference> getRootPortablePreferences() {
        return this.preferences.select(new Annotation[]{rootPreferenceAnnotation});
    }

    <U extends BasePreference<U>, T extends BasePreferencePortable<U>> T lookupPortablePreference(Class<U> clazz) {
        return (T)((BasePreferencePortable)this.preferences.select(clazz, new Annotation[]{portablePreferenceAnnotation}).get());
    }
}

