/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.annotations.Customizable;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.preferences.shared.PreferenceScope;
import org.uberfire.ext.preferences.shared.PreferenceScopeFactory;
import org.uberfire.ext.preferences.shared.PreferenceScopeTypes;
import org.uberfire.ext.preferences.shared.PreferenceStorage;
import org.uberfire.ext.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.ext.preferences.shared.impl.PreferenceScopedValue;
import org.uberfire.ext.preferences.shared.impl.exception.InvalidPreferenceScopeException;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.rpc.SessionInfo;

@ApplicationScoped
public class PreferenceStorageImpl
implements PreferenceStorage {
    private static final Logger logger = LoggerFactory.getLogger(PreferenceStorageImpl.class);
    public static final String FILE_FORMAT = ".preferences";
    public static final int FILE_FORMAT_SIZE = ".preferences".length();
    private IOService ioService;
    private SessionInfo sessionInfo;
    private PreferenceScopeTypes scopeTypes;
    private PreferenceScopeFactory scopeFactory;
    private ObjectStorage objectStorage;

    protected PreferenceStorageImpl() {
    }

    @Inject
    public PreferenceStorageImpl(@Named(value="ioStrategy") IOService ioService, SessionInfo sessionInfo, @Customizable PreferenceScopeTypes scopeTypes, PreferenceScopeFactory scopeFactory, ObjectStorage objectStorage) {
        this.ioService = ioService;
        this.sessionInfo = sessionInfo;
        this.scopeTypes = scopeTypes;
        this.scopeFactory = scopeFactory;
        this.objectStorage = objectStorage;
    }

    @PostConstruct
    public void init() {
        String rootPath = "git://preferences";
        this.objectStorage.init("git://preferences");
    }

    public boolean exists(PreferenceScope preferenceScope, String key) {
        return this.objectStorage.exists(this.buildScopedPreferencePath(preferenceScope, key));
    }

    public boolean exists(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, String key) {
        for (PreferenceScope preferenceScope : scopeResolutionStrategyInfo.order()) {
            boolean exists = this.exists(preferenceScope, key);
            if (!exists) continue;
            return true;
        }
        return false;
    }

    public <T> T read(PreferenceScope preferenceScope, String key) {
        String path = this.buildScopedPreferencePath(preferenceScope, key);
        return (T)this.objectStorage.read(path);
    }

    public <T> T read(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, String key) {
        for (PreferenceScope preferenceScope : scopeResolutionStrategyInfo.order()) {
            T result = this.read(preferenceScope, key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public <T> PreferenceScopedValue<T> readWithScope(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, String key) {
        for (PreferenceScope scope : scopeResolutionStrategyInfo.order()) {
            T result = this.read(scope, key);
            if (result == null) continue;
            return new PreferenceScopedValue(result, this.scopeFactory.cloneScope(scope));
        }
        return null;
    }

    public void write(PreferenceScope preferenceScope, String key, Object value) {
        this.objectStorage.write(this.buildScopedPreferencePath(preferenceScope, key), value);
    }

    public void delete(PreferenceScope preferenceScope, String key) {
        this.objectStorage.delete(this.buildScopedPreferencePath(preferenceScope, key));
    }

    public Collection<String> allKeys(PreferenceScope scope) {
        final ArrayList<String> keys = new ArrayList<String>();
        Path path = this.objectStorage.getPath(this.buildScopePath(scope), new String[0]);
        if (this.ioService.exists(path)) {
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"path", (Object)path)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        String fileName = file.getFileName().toString();
                        int keyEndIndex = fileName.length() - FILE_FORMAT_SIZE;
                        String fileNameWithoutFormat = fileName.substring(0, keyEndIndex);
                        keys.add(fileNameWithoutFormat);
                    }
                    catch (Exception ex) {
                        logger.error("An unexpected exception was thrown: ", (Throwable)ex);
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return keys;
    }

    public Collection<String> allKeys(List<PreferenceScope> scopes) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        scopes.forEach(scope -> keys.addAll(this.allKeys((PreferenceScope)scope)));
        return keys;
    }

    String buildScopePath(PreferenceScope scope) {
        if (scope == null) {
            throw new InvalidPreferenceScopeException("The scope must not be null when building a scope path.");
        }
        String path = "/config/";
        for (PreferenceScope currentScope = scope; currentScope != null; currentScope = currentScope.childScope()) {
            path = path + currentScope.type() + "/" + currentScope.key() + "/";
        }
        return path;
    }

    String buildScopedPreferencePath(PreferenceScope scope, String key) {
        return this.buildScopePath(scope) + key + FILE_FORMAT;
    }
}

