/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.admin.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.preferences.client.admin.page.AdminPage;
import org.uberfire.ext.preferences.client.admin.page.AdminTool;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class AdminPageImpl
implements AdminPage {
    private PlaceManager placeManager;
    private Map<String, String> screenTitleByIdentifier;
    private Map<String, Map<String, List<AdminTool>>> toolsByCategoryByScreen;

    public AdminPageImpl() {
        this(null);
    }

    @Inject
    public AdminPageImpl(PlaceManager placeManager) {
        this.placeManager = placeManager;
        this.toolsByCategoryByScreen = new HashMap<String, Map<String, List<AdminTool>>>();
        this.screenTitleByIdentifier = new HashMap<String, String>();
    }

    @Override
    public void addScreen(String identifier, String title) {
        if (identifier == null || identifier.isEmpty()) {
            throw new RuntimeException("The screen identifier must be not empty.");
        }
        this.screenTitleByIdentifier.put(identifier, title);
        this.toolsByCategoryByScreen.put(identifier, new LinkedHashMap());
    }

    @Override
    public void addTool(String screen, String title, String iconCss, String category, Command command, ParameterizedCommand<ParameterizedCommand<Integer>> counterCommand) {
        if (screen == null || screen.isEmpty()) {
            throw new RuntimeException("The screen identifier must be not empty.");
        }
        if (this.screenTitleByIdentifier.get(screen) == null) {
            throw new RuntimeException("The screen must be added before it is used.");
        }
        if (category == null || category.isEmpty()) {
            throw new RuntimeException("The category identifier must be not empty.");
        }
        Map<String, List<AdminTool>> toolsByCategory = this.toolsByCategoryByScreen.get(screen);
        List<AdminTool> tools = toolsByCategory.get(category);
        if (tools == null) {
            tools = new ArrayList<AdminTool>();
            toolsByCategory.put(category, tools);
        }
        AdminTool tool = new AdminTool(title, iconCss, category, command, counterCommand);
        tools.add(tool);
    }

    @Override
    public void addTool(String screen, String title, String iconCss, String category, Command command) {
        this.addTool(screen, title, iconCss, category, command, null);
    }

    @Override
    public void addPreference(String screen, String identifier, String title, String iconCss, String category) {
        this.addPreference(screen, identifier, title, iconCss, category, null);
    }

    @Override
    public void addPreference(String screen, String identifier, String title, String iconCss, String category, Map<String, String> customScopeResolutionStrategyParams) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (customScopeResolutionStrategyParams != null && !customScopeResolutionStrategyParams.isEmpty()) {
            parameters.putAll(customScopeResolutionStrategyParams);
            parameters.put("customScopeResolutionStrategy", "true");
        }
        parameters.put("identifier", identifier);
        parameters.put("title", title);
        parameters.put("screen", screen);
        this.addTool(screen, title, iconCss, category, () -> this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("PreferencesCentralPerspective", parameters)));
    }

    @Override
    public Map<String, List<AdminTool>> getToolsByCategory(String screen) {
        return this.toolsByCategoryByScreen.get(screen);
    }

    @Override
    public String getScreenTitle(String screen) {
        return this.screenTitleByIdentifier.get(screen);
    }
}

