/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.annotations.Customizable;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyStructurePresenter;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyStructureView;
import org.uberfire.ext.preferences.client.central.tree.TreeView;
import org.uberfire.ext.preferences.shared.CustomPreferenceScopeResolutionStrategyInfoFactory;
import org.uberfire.ext.preferences.shared.bean.PreferenceBeanServerStore;
import org.uberfire.ext.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.CompassPosition;

@WorkbenchScreen(identifier="PreferencesCentralNavBarScreen")
public class PreferencesCentralNavBarScreen {
    public static final String IDENTIFIER = "PreferencesCentralNavBarScreen";
    private final HierarchyStructurePresenter hierarchyStructurePresenter;
    private final Caller<PreferenceBeanServerStore> preferenceBeanServerStoreCaller;
    private final Event<NotificationEvent> notification;
    private final CustomPreferenceScopeResolutionStrategyInfoFactory scopeResolutionStrategyInfoFactory;

    @Inject
    public PreferencesCentralNavBarScreen(@TreeView HierarchyStructurePresenter treePresenter, Caller<PreferenceBeanServerStore> preferenceBeanServerStoreCaller, Event<NotificationEvent> notification, @Customizable CustomPreferenceScopeResolutionStrategyInfoFactory scopeResolutionStrategyInfoFactory) {
        this.hierarchyStructurePresenter = treePresenter;
        this.preferenceBeanServerStoreCaller = preferenceBeanServerStoreCaller;
        this.notification = notification;
        this.scopeResolutionStrategyInfoFactory = scopeResolutionStrategyInfoFactory;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        String preferenceIdentifier = placeRequest.getParameter("identifier", null);
        String customScopeResolutionStrategy = placeRequest.getParameter("customScopeResolutionStrategy", "false");
        if (Boolean.valueOf(customScopeResolutionStrategy) != null) {
            HashMap<String, String> params = new HashMap<String, String>(placeRequest.getParameters());
            this.cleanParametersToCreateScopeResolutionStrategy(params);
            PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo = this.scopeResolutionStrategyInfoFactory.create(params);
            this.hierarchyStructurePresenter.init(preferenceIdentifier, scopeResolutionStrategyInfo);
        } else {
            this.hierarchyStructurePresenter.init(preferenceIdentifier);
        }
    }

    private void cleanParametersToCreateScopeResolutionStrategy(Map<String, String> params) {
        params.remove("identifier");
        params.remove("title");
        params.remove("screen");
        params.remove("customScopeResolutionStrategy");
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Preferences Central";
    }

    @WorkbenchPartView
    public HierarchyStructureView getView() {
        return this.hierarchyStructurePresenter.getView();
    }

    @DefaultPosition
    public CompassPosition getDefaultPosition() {
        return CompassPosition.WEST;
    }
}

