/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.annotations.WorkbenchPerspective;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDockReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelPresenter;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@ApplicationScoped
@WorkbenchPerspective(identifier="PreferencesCentralPerspective")
public class PreferencesCentralPerspective {
    public static final String IDENTIFIER = "PreferencesCentralPerspective";
    @Inject
    private UberfireDocks uberfireDocks;
    private UberfireDock dock;
    private PerspectiveDefinition perspective;

    public void perspectiveChangeEvent(@Observes UberfireDockReadyEvent dockReadyEvent) {
        if (dockReadyEvent.getCurrentPerspective().equals(IDENTIFIER)) {
            this.uberfireDocks.expand(this.dock);
        }
    }

    @Perspective
    public PerspectiveDefinition getPerspective() {
        if (this.perspective == null) {
            return this.createPerspectiveDefinition();
        }
        return this.perspective;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.perspective = this.createPerspectiveDefinition();
        this.configurePerspective(placeRequest);
    }

    PerspectiveDefinition createPerspectiveDefinition() {
        PerspectiveDefinitionImpl perspective = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        perspective.setName("Preferences");
        return perspective;
    }

    void configurePerspective(PlaceRequest placeRequest) {
        PanelDefinitionImpl actionsBar = new PanelDefinitionImpl(StaticWorkbenchPanelPresenter.class.getName());
        actionsBar.setHeight(80);
        actionsBar.addPart((PartDefinition)new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("PreferencesCentralActionsScreen", placeRequest.getParameters())));
        this.perspective.getRoot().insertChild((Position)CompassPosition.SOUTH, (PanelDefinition)actionsBar);
        this.setupNavBarDock((PlaceRequest)new DefaultPlaceRequest("PreferencesCentralNavBarScreen", placeRequest.getParameters()));
    }

    private void setupNavBarDock(PlaceRequest placeRequest) {
        String title = placeRequest.getParameter("title", null);
        if (this.dock != null) {
            this.uberfireDocks.remove(new UberfireDock[]{this.dock});
        }
        this.dock = new UberfireDock(UberfireDockPosition.WEST, "ADJUST", placeRequest, IDENTIFIER).withSize(420.0).withLabel(title);
        this.uberfireDocks.add(new UberfireDock[]{this.dock});
    }
}

