/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.actions;

import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyStructureView;
import org.uberfire.ext.preferences.client.event.PreferencesCentralPreSaveEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralSaveEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralUndoChangesEvent;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.CompassPosition;

@WorkbenchScreen(identifier="PreferencesCentralActionsScreen")
public class PreferencesCentralActionsScreen {
    public static final String IDENTIFIER = "PreferencesCentralActionsScreen";
    private final View view;
    private final PlaceManager placeManager;
    private final Event<PreferencesCentralPreSaveEvent> preSaveEvent;
    private final Event<PreferencesCentralSaveEvent> saveEvent;
    private final Event<PreferencesCentralUndoChangesEvent> undoChangesEvent;
    private final Event<NotificationEvent> notification;
    private String adminPageScreenToGoBack;

    @Inject
    public PreferencesCentralActionsScreen(View view, PlaceManager placeManager, Event<PreferencesCentralPreSaveEvent> preSaveEvent, Event<PreferencesCentralSaveEvent> saveEvent, Event<PreferencesCentralUndoChangesEvent> undoChangesEvent, Event<NotificationEvent> notification) {
        this.view = view;
        this.placeManager = placeManager;
        this.preSaveEvent = preSaveEvent;
        this.saveEvent = saveEvent;
        this.undoChangesEvent = undoChangesEvent;
        this.notification = notification;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.adminPageScreenToGoBack = placeRequest.getParameter("screen", null);
    }

    public void fireSaveEvent() {
        this.preSaveEvent.fire((Object)new PreferencesCentralPreSaveEvent());
        this.saveEvent.fire((Object)new PreferencesCentralSaveEvent());
        this.goBackToHome();
    }

    public void fireCancelEvent() {
        this.undoChangesEvent.fire((Object)new PreferencesCentralUndoChangesEvent());
        this.notification.fire((Object)new NotificationEvent(this.view.getChangesUndoneMessage(), NotificationEvent.NotificationType.DEFAULT));
        this.goBackToHome();
    }

    private void goBackToHome() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("screen", this.adminPageScreenToGoBack);
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("AdminPagePerspective", params));
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "";
    }

    @WorkbenchPartView
    public HierarchyStructureView getView() {
        return this.view;
    }

    @DefaultPosition
    public CompassPosition getDefaultPosition() {
        return CompassPosition.SOUTH;
    }

    public static interface View
    extends HierarchyStructureView,
    UberElement<PreferencesCentralActionsScreen> {
        public String getChangesUndoneMessage();
    }
}

