/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyItemPresenter;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyStructurePresenter;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyStructureView;
import org.uberfire.ext.preferences.client.central.tree.TreeHierarchyInternalItemPresenter;
import org.uberfire.ext.preferences.client.central.tree.TreeHierarchyLeafItemPresenter;
import org.uberfire.ext.preferences.client.central.tree.TreeView;
import org.uberfire.ext.preferences.client.event.HierarchyItemFormInitializationEvent;
import org.uberfire.ext.preferences.client.event.HierarchyItemSelectedEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralSaveEvent;
import org.uberfire.ext.preferences.client.utils.PreferenceFormBeansInfo;
import org.uberfire.ext.preferences.shared.bean.BasePreference;
import org.uberfire.ext.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.ext.preferences.shared.bean.PreferenceBeanServerStore;
import org.uberfire.ext.preferences.shared.bean.PreferenceBeanStore;
import org.uberfire.ext.preferences.shared.bean.PreferenceHierarchyElement;
import org.uberfire.ext.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@TreeView
@Dependent
public class TreeHierarchyStructurePresenter
implements HierarchyStructurePresenter {
    private final View view;
    private final Caller<PreferenceBeanServerStore> preferenceBeanServerStoreCaller;
    private final ManagedInstance<TreeHierarchyInternalItemPresenter> treeHierarchyInternalItemPresenterProvider;
    private final ManagedInstance<TreeHierarchyLeafItemPresenter> treeHierarchyLeafItemPresenterProvider;
    private final Event<HierarchyItemFormInitializationEvent> hierarchyItemFormInitializationEvent;
    private final PlaceManager placeManager;
    private final PreferenceBeanStore store;
    private final Event<NotificationEvent> notification;
    private final PreferenceFormBeansInfo preferenceFormBeansInfo;
    private HierarchyItemPresenter hierarchyItem;
    private PreferenceHierarchyElement<?> preferenceElement;
    private PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategyInfo;

    @Inject
    public TreeHierarchyStructurePresenter(View view, Caller<PreferenceBeanServerStore> preferenceBeanServerStoreCaller, ManagedInstance<TreeHierarchyInternalItemPresenter> treeHierarchyInternalItemPresenterProvider, ManagedInstance<TreeHierarchyLeafItemPresenter> treeHierarchyLeafItemPresenterProvider, Event<HierarchyItemFormInitializationEvent> hierarchyItemFormInitializationEvent, PlaceManager placeManager, PreferenceBeanStore store, Event<NotificationEvent> notification, PreferenceFormBeansInfo preferenceFormBeansInfo) {
        this.view = view;
        this.preferenceBeanServerStoreCaller = preferenceBeanServerStoreCaller;
        this.treeHierarchyInternalItemPresenterProvider = treeHierarchyInternalItemPresenterProvider;
        this.treeHierarchyLeafItemPresenterProvider = treeHierarchyLeafItemPresenterProvider;
        this.hierarchyItemFormInitializationEvent = hierarchyItemFormInitializationEvent;
        this.placeManager = placeManager;
        this.store = store;
        this.notification = notification;
        this.preferenceFormBeansInfo = preferenceFormBeansInfo;
    }

    @Override
    public void init(String rootIdentifier) {
        this.init(rootIdentifier, null);
    }

    @Override
    public void init(String rootIdentifier, PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategyInfo) {
        final TreeHierarchyStructurePresenter presenter = this;
        this.customScopeResolutionStrategyInfo = customScopeResolutionStrategyInfo;
        ((PreferenceBeanServerStore)this.preferenceBeanServerStoreCaller.call(new RemoteCallback<PreferenceHierarchyElement<?>>(){

            public void callback(PreferenceHierarchyElement<?> rootPreference) {
                TreeHierarchyStructurePresenter.this.preferenceElement = rootPreference;
                if (rootPreference.hasChildren()) {
                    TreeHierarchyStructurePresenter.this.hierarchyItem = (HierarchyItemPresenter)TreeHierarchyStructurePresenter.this.treeHierarchyInternalItemPresenterProvider.get();
                } else {
                    TreeHierarchyStructurePresenter.this.hierarchyItem = (HierarchyItemPresenter)TreeHierarchyStructurePresenter.this.treeHierarchyLeafItemPresenterProvider.get();
                }
                TreeHierarchyStructurePresenter.this.hierarchyItem.init(rootPreference, 0);
                TreeHierarchyStructurePresenter.this.hierarchyItem.fireSelect();
                TreeHierarchyStructurePresenter.this.view.init(presenter);
            }
        }, (message, throwable) -> {
            throw new RuntimeException(throwable);
        })).buildHierarchyStructureForPreference(rootIdentifier);
    }

    public void hierarchyItemSelectedEvent(@Observes HierarchyItemSelectedEvent hierarchyItemSelectedEvent) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", hierarchyItemSelectedEvent.getItemId());
        parameters.put("title", this.view.getTranslation(hierarchyItemSelectedEvent.getPreference().bundleKey()));
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(this.getPreferenceFormIdentifier(hierarchyItemSelectedEvent.getPreferenceIdentifier()), parameters));
        HierarchyItemFormInitializationEvent event = new HierarchyItemFormInitializationEvent(hierarchyItemSelectedEvent.getHierarchyElement());
        this.hierarchyItemFormInitializationEvent.fire((Object)event);
    }

    public void saveEvent(@Observes PreferencesCentralSaveEvent event) {
        Collection<BasePreferencePortable<? extends BasePreference<?>>> preferencesToSave = this.getPreferencesToSave(this.preferenceElement);
        if (this.customScopeResolutionStrategyInfo != null) {
            this.store.save(preferencesToSave, this.customScopeResolutionStrategyInfo, () -> this.notification.fire((Object)new NotificationEvent(this.view.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS)), parameter -> this.notification.fire((Object)new NotificationEvent("Unexpected error while saving: " + parameter.getMessage(), NotificationEvent.NotificationType.ERROR)));
        } else {
            this.store.save(preferencesToSave, () -> this.notification.fire((Object)new NotificationEvent(this.view.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS)), parameter -> this.notification.fire((Object)new NotificationEvent("Unexpected error while saving: " + parameter.getMessage(), NotificationEvent.NotificationType.ERROR)));
        }
    }

    private Collection<BasePreferencePortable<? extends BasePreference<?>>> getPreferencesToSave(PreferenceHierarchyElement<?> preferenceElement) {
        ArrayList preferencesToSave = new ArrayList();
        if (preferenceElement.isRoot()) {
            preferencesToSave.add(preferenceElement.getPortablePreference());
        }
        preferenceElement.getChildren().forEach(childElement -> preferencesToSave.addAll(this.getPreferencesToSave((PreferenceHierarchyElement<?>)childElement)));
        return preferencesToSave;
    }

    public HierarchyItemPresenter getHierarchyItem() {
        return this.hierarchyItem;
    }

    public String getPreferenceFormIdentifier(String preferenceIdentifier) {
        String customForm = this.preferenceFormBeansInfo.getPreferenceFormFor(preferenceIdentifier);
        return customForm != null ? customForm : "org.uberfire.ext.preferences.client.central.form.DefaultPreferenceForm";
    }

    @Override
    public View getView() {
        return this.view;
    }

    public static interface View
    extends HierarchyStructureView,
    UberElement<TreeHierarchyStructurePresenter> {
        public String getTranslation(String var1);

        public String getSaveSuccessMessage();
    }
}

