/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.tree;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyInternalItemPresenter;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyItemPresenter;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyItemView;
import org.uberfire.ext.preferences.client.central.tree.TreeHierarchyLeafItemPresenter;
import org.uberfire.ext.preferences.client.event.HierarchyItemSelectedEvent;
import org.uberfire.preferences.shared.bean.PreferenceHierarchyElement;

public class TreeHierarchyInternalItemPresenter
implements HierarchyInternalItemPresenter {
    private final View view;
    private final ManagedInstance<TreeHierarchyInternalItemPresenter> treeHierarchyInternalItemPresenterProvider;
    private final ManagedInstance<TreeHierarchyLeafItemPresenter> treeHierarchyLeafItemPresenterProvider;
    private final Event<HierarchyItemSelectedEvent> hierarchyItemSelectedEvent;
    private List<HierarchyItemPresenter> hierarchyItems;
    private PreferenceHierarchyElement<?> hierarchyElement;
    private int level;

    @Inject
    public TreeHierarchyInternalItemPresenter(View view, ManagedInstance<TreeHierarchyInternalItemPresenter> treeHierarchyInternalItemPresenterProvider, ManagedInstance<TreeHierarchyLeafItemPresenter> treeHierarchyLeafItemPresenterProvider, Event<HierarchyItemSelectedEvent> hierarchyItemSelectedEvent) {
        this.view = view;
        this.treeHierarchyInternalItemPresenterProvider = treeHierarchyInternalItemPresenterProvider;
        this.treeHierarchyLeafItemPresenterProvider = treeHierarchyLeafItemPresenterProvider;
        this.hierarchyItemSelectedEvent = hierarchyItemSelectedEvent;
    }

    @Override
    public <T> void init(PreferenceHierarchyElement<T> preference, int level, boolean tryToSelectChild) {
        this.hierarchyElement = preference;
        this.level = level;
        this.hierarchyItems = new ArrayList<HierarchyItemPresenter>();
        for (PreferenceHierarchyElement child : preference.getChildren()) {
            HierarchyItemPresenter hierarchyItem = child.hasChildren() ? (HierarchyItemPresenter)this.treeHierarchyInternalItemPresenterProvider.get() : (HierarchyItemPresenter)this.treeHierarchyLeafItemPresenterProvider.get();
            hierarchyItem.init(child, level + 1, tryToSelectChild && !child.isSelectable());
            if (child.isSelectable()) {
                hierarchyItem.fireSelect();
                tryToSelectChild = false;
            }
            this.hierarchyItems.add(hierarchyItem);
        }
        this.view.init(this);
    }

    @Override
    public void fireSelect() {
        this.view.select();
    }

    public void select() {
        if (this.hierarchyElement.isSelectable()) {
            HierarchyItemSelectedEvent event = new HierarchyItemSelectedEvent(this.hierarchyElement);
            this.hierarchyItemSelectedEvent.fire((Object)event);
            this.view.selectElement();
        }
    }

    public void hierarchyItemSelectedEvent(@Observes HierarchyItemSelectedEvent hierarchyItemSelectedEvent) {
        if (!this.hierarchyElement.getId().equals(hierarchyItemSelectedEvent.getHierarchyElement().getId())) {
            this.view.deselect();
        }
    }

    @Override
    public View getView() {
        return this.view;
    }

    public PreferenceHierarchyElement<?> getHierarchyElement() {
        return this.hierarchyElement;
    }

    public List<HierarchyItemPresenter> getHierarchyItems() {
        return this.hierarchyItems;
    }

    public int getLevel() {
        return this.level;
    }

    public static interface View
    extends HierarchyItemView,
    UberElement<TreeHierarchyInternalItemPresenter> {
        public void select();

        public void selectElement();
    }
}

