/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.preferences.scope;

import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.preferences.scope.UserProjectPreferenceScope;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.preferences.shared.PreferenceScopeTypes;
import org.uberfire.preferences.shared.impl.PreferenceScopeFactoryImpl;

public class UserProjectPreferenceScopeTest {
    private PreferenceScopeTypes scopeTypes;
    private PreferenceScopeFactory scopeFactory;
    private ProjectContext projectContext;
    private UserProjectPreferenceScope userProjectScope;

    @Before
    public void setup() {
        this.scopeTypes = (PreferenceScopeTypes)Mockito.mock(PreferenceScopeTypes.class);
        ((PreferenceScopeTypes)Mockito.doReturn((Object)"admin").when((Object)this.scopeTypes)).getDefaultKeyFor("user");
        ((PreferenceScopeTypes)Mockito.doReturn((Object)false).when((Object)this.scopeTypes)).typeRequiresKey("user");
        ((PreferenceScopeTypes)Mockito.doReturn((Object)true).when((Object)this.scopeTypes)).typeRequiresKey("project");
        this.scopeFactory = new PreferenceScopeFactoryImpl(this.scopeTypes);
        this.projectContext = (ProjectContext)Mockito.mock(ProjectContext.class);
        this.userProjectScope = new UserProjectPreferenceScope(this.scopeFactory, this.projectContext);
    }

    @Test
    public void userProjectScopeIsResolvedWithCustomProjectCorrectlyTest() {
        Project project = (Project)Mockito.mock(Project.class);
        ((Project)Mockito.doReturn((Object)"identifier").when((Object)project)).getEncodedIdentifier();
        this.userProjectScope.forProject(project);
        PreferenceScope resolvedUserProjectScope = this.userProjectScope.resolve();
        Assert.assertEquals((Object)"user", (Object)resolvedUserProjectScope.type());
        Assert.assertEquals((Object)"admin", (Object)resolvedUserProjectScope.key());
        Assert.assertNotNull((Object)resolvedUserProjectScope.childScope());
        Assert.assertEquals((Object)"project", (Object)resolvedUserProjectScope.childScope().type());
        Assert.assertEquals((Object)"identifier", (Object)resolvedUserProjectScope.childScope().key());
        Assert.assertNull((Object)resolvedUserProjectScope.childScope().childScope());
    }

    @Test
    public void userProjectScopeIsResolvedWithActiveProjectCorrectlyTest() {
        Project project = (Project)Mockito.mock(Project.class);
        ((Project)Mockito.doReturn((Object)"identifier").when((Object)project)).getEncodedIdentifier();
        ((ProjectContext)Mockito.doReturn((Object)project).when((Object)this.projectContext)).getActiveProject();
        PreferenceScope resolvedUserProjectScope = this.userProjectScope.resolve();
        Assert.assertEquals((Object)"user", (Object)resolvedUserProjectScope.type());
        Assert.assertEquals((Object)"admin", (Object)resolvedUserProjectScope.key());
        Assert.assertNotNull((Object)resolvedUserProjectScope.childScope());
        Assert.assertEquals((Object)"project", (Object)resolvedUserProjectScope.childScope().type());
        Assert.assertEquals((Object)"identifier", (Object)resolvedUserProjectScope.childScope().key());
        Assert.assertNull((Object)resolvedUserProjectScope.childScope().childScope());
    }

    @Test(expected=RuntimeException.class)
    public void userProjectScopeIsNotResolvedWhenProjectIsNotPassedTest() {
        this.userProjectScope.resolve();
    }
}

