/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.model;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.project.model.Build;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepository;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class POM {
    private static final String MODEL_VERSION = "4.0.0";
    private GAV parent;
    private GAV gav;
    private String name;
    private String description;
    private String url;
    private String packaging;
    private Build build;
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private List<MavenRepository> repositories = new ArrayList<MavenRepository>();
    private List<String> modules = new ArrayList<String>();

    public POM() {
        this.gav = new GAV();
    }

    public POM(GAV gav) {
        this(null, null, null, gav, false);
    }

    public POM(String name, String description, String url, GAV gav) {
        this(name, description, url, gav, false);
    }

    public POM(String name, String description, String url, GAV gav, boolean multiModule) {
        this.name = name;
        this.description = description;
        this.url = url;
        this.gav = gav;
        if (multiModule) {
            this.packaging = "pom";
        }
    }

    public GAV getGav() {
        return this.gav;
    }

    public Dependencies getDependencies() {
        return new Dependencies(this.dependencies);
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void addRepository(MavenRepository mavenRepository) {
        this.repositories.add(mavenRepository);
    }

    public List<MavenRepository> getRepositories() {
        return this.repositories;
    }

    public String getModelVersion() {
        return MODEL_VERSION;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public GAV getParent() {
        return this.parent;
    }

    public void setParent(GAV parent) {
        this.parent = parent;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public Build getBuild() {
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    public boolean isMultiModule() {
        return "pom".equals(this.packaging);
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        POM pom = (POM)o;
        if (this.packaging != null ? !this.packaging.equals(pom.packaging) : pom.packaging != null) {
            return false;
        }
        if (this.dependencies != null ? !this.dependencies.equals(pom.dependencies) : pom.dependencies != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(pom.description) : pom.description != null) {
            return false;
        }
        if (this.gav != null ? !this.gav.equals(pom.gav) : pom.gav != null) {
            return false;
        }
        if (this.modules != null ? !this.modules.equals(pom.modules) : pom.modules != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(pom.name) : pom.name != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(pom.parent) : pom.parent != null) {
            return false;
        }
        return !(this.repositories != null ? !this.repositories.equals(pom.repositories) : pom.repositories != null);
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = ~(~result);
        result = 31 * result + (this.gav != null ? this.gav.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.packaging != null ? this.packaging.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.dependencies != null ? this.dependencies.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.repositories != null ? this.repositories.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.modules != null ? this.modules.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

