/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.model;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.junit.Before;
import org.junit.Test;

public class DependenciesTest {
    private Dependencies dependencies;
    private Dependency droolsCore;

    @Before
    public void setUp() {
        this.dependencies = new Dependencies();
        this.droolsCore = new Dependency(new GAV("org.drools:drools-core:5.0"));
        this.droolsCore.setScope("compile");
        this.dependencies.add(this.droolsCore);
        Dependency junit = new Dependency(new GAV("junit:junit:4.11"));
        junit.setScope("test");
        this.dependencies.add(junit);
        Dependency depWithoutScope = new Dependency(new GAV("mygroup:depWithoutScope:1.0"));
        this.dependencies.add(depWithoutScope);
    }

    @Test
    public void testGetAllGAVs() {
        Collection gavs = this.dependencies.getGavs(new String[0]);
        Assertions.assertThat((int)gavs.size()).isEqualTo(3);
        DependenciesTest.assertContains(gavs, "org.drools", "drools-core", "5.0");
        DependenciesTest.assertContains(gavs, "junit", "junit", "4.11");
        DependenciesTest.assertContains(gavs, "mygroup", "depWithoutScope", "1.0");
    }

    @Test
    public void testFindByGav() {
        Assertions.assertThat((Object)this.dependencies.get(new GAV("org.drools:drools-core:5.0"))).isEqualTo((Object)this.droolsCore);
    }

    @Test
    public void testNullWhenNoResults() {
        Assertions.assertThat((Object)this.dependencies.get(new GAV("org.drools:drools-core:112.0"))).isNull();
    }

    private static void assertContains(Collection<GAV> gavs, String groupID, String artifactID, String version) {
        for (GAV gav : gavs) {
            if (!gav.getArtifactId().equals(artifactID) || !gav.getGroupId().equals(groupID) || !gav.getVersion().equals(version)) continue;
            return;
        }
        Assertions.fail((String)("Could not find " + groupID + ":" + artifactID + ":" + version));
    }

    @Test
    public void testContainsGAV() {
        Assertions.assertThat((boolean)this.dependencies.containsDependency(new GAV("org.drools:drools-core:5.0"))).isTrue();
        Dependency dependency = new Dependency(new GAV("org.drools:drools-core:5.0"));
        dependency.setScope("test");
        Assertions.assertThat((boolean)this.dependencies.containsDependency((GAV)dependency)).isTrue();
        Assertions.assertThat((boolean)this.dependencies.containsDependency(new GAV("org.drools:drools-core:4.0"))).isFalse();
    }

    @Test
    public void testGetTestScopedGAVs() {
        Collection gavs = this.dependencies.getGavs(new String[]{"test"});
        Assertions.assertThat((Iterable)gavs).hasSize(1);
        DependenciesTest.assertContains(gavs, "junit", "junit", "4.11");
    }

    @Test
    public void testGetCompileScopedGAVs() {
        Collection gavs = this.dependencies.getGavs(new String[]{"compile"});
        Assertions.assertThat((Iterable)gavs).hasSize(1);
        DependenciesTest.assertContains(gavs, "org.drools", "drools-core", "5.0");
    }

    @Test
    public void testGetCompileScopedGavsMethod() {
        Collection gavs = this.dependencies.getCompileScopedGavs();
        Assertions.assertThat((Iterable)gavs).hasSize(2);
        DependenciesTest.assertContains(gavs, "org.drools", "drools-core", "5.0");
        DependenciesTest.assertContains(gavs, "mygroup", "depWithoutScope", "1.0");
    }
}

