/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.events.DeleteProjectEvent;
import org.guvnor.common.services.project.model.Project;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceDeleted;
import org.uberfire.workbench.events.ResourceDeletedEvent;

public abstract class AbstractDeleteProjectObserverBridge<T extends Project> {
    private IOService ioService;
    private Event<DeleteProjectEvent> deleteProjectEvent;

    public AbstractDeleteProjectObserverBridge() {
    }

    public AbstractDeleteProjectObserverBridge(IOService ioService, Event<DeleteProjectEvent> deleteProjectEvent) {
        this.ioService = (IOService)PortablePreconditions.checkNotNull((String)"ioService", (Object)ioService);
        this.deleteProjectEvent = (Event)PortablePreconditions.checkNotNull((String)"deleteProjectEvent", deleteProjectEvent);
    }

    public void onBatchResourceChanges(ResourceDeletedEvent event) {
        if (event.getPath().getFileName().equals("pom.xml")) {
            this.fireDeleteEvent(event.getPath());
        }
    }

    public void onBatchResourceChanges(ResourceBatchChangesEvent resourceBatchChangesEvent) {
        for (Map.Entry entry : resourceBatchChangesEvent.getBatch().entrySet()) {
            if (!((org.uberfire.backend.vfs.Path)entry.getKey()).getFileName().equals("pom.xml") || !this.isDelete((Collection)entry.getValue())) continue;
            this.fireDeleteEvent((org.uberfire.backend.vfs.Path)entry.getKey());
        }
    }

    private boolean isDelete(Collection<ResourceChange> value) {
        for (ResourceChange resourceChange : value) {
            if (!(resourceChange instanceof ResourceDeleted)) continue;
            return true;
        }
        return false;
    }

    private void fireDeleteEvent(org.uberfire.backend.vfs.Path _path) {
        Path path = this.ioService.get(URI.create(_path.toURI()));
        T project = this.getProject(path.getParent());
        this.deleteProjectEvent.fire((Object)new DeleteProjectEvent(project));
    }

    protected abstract T getProject(Path var1);
}

