/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.security;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.guvnor.common.services.project.security.ProjectPermissionsService;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;

public class ProjectPermissionsServiceImpl
implements ProjectPermissionsService {
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;

    public ProjectPermissionsServiceImpl() {
    }

    @Inject
    public ProjectPermissionsServiceImpl(SpaceConfigStorageRegistry spaceConfigStorageRegistry) {
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
    }

    public BranchPermissions loadBranchPermissions(String spaceName, String projectIdentifier, String branchName) {
        return this.spaceConfigStorageRegistry.get(spaceName).loadBranchPermissions(branchName, projectIdentifier);
    }

    public Map<String, BranchPermissions> loadBranchPermissions(String spaceName, String projectIdentifier, List<String> branches) {
        return branches.stream().collect(Collectors.toMap(Function.identity(), branch -> this.loadBranchPermissions(spaceName, projectIdentifier, (String)branch)));
    }
}

