/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Event;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.ModuleFinder;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.builder.events.InvalidateDMOModuleCacheEvent;
import org.guvnor.common.services.project.events.NewModuleEvent;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.project.ModuleFactory;
import org.guvnor.common.services.project.service.ModuleServiceCore;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.rpc.SessionInfo;

public abstract class AbstractModuleService<T extends Module>
implements ModuleServiceCore<T>,
ModuleFactory<T> {
    protected IOService ioService;
    protected POMService pomService;
    private RepositoryService repoService;
    protected Event<NewModuleEvent> newModuleEvent;
    protected Event<NewPackageEvent> newPackageEvent;
    protected CommentedOptionFactory commentedOptionFactory;
    protected ResourceResolver resourceResolver;
    protected SessionInfo sessionInfo;
    private ModuleFinder moduleFinder;
    private Event<InvalidateDMOModuleCacheEvent> invalidateDMOCache;

    protected AbstractModuleService() {
    }

    public AbstractModuleService(IOService ioService, POMService pomService, RepositoryService repoService, Event<NewModuleEvent> newModuleEvent, Event<NewPackageEvent> newPackageEvent, Event<InvalidateDMOModuleCacheEvent> invalidateDMOCache, SessionInfo sessionInfo, CommentedOptionFactory commentedOptionFactory, ModuleFinder moduleFinder, ResourceResolver resourceResolver) {
        this.ioService = ioService;
        this.pomService = pomService;
        this.repoService = repoService;
        this.newModuleEvent = newModuleEvent;
        this.newPackageEvent = newPackageEvent;
        this.invalidateDMOCache = invalidateDMOCache;
        this.commentedOptionFactory = commentedOptionFactory;
        this.moduleFinder = moduleFinder;
        this.resourceResolver = resourceResolver;
        this.sessionInfo = new SafeSessionInfo(sessionInfo);
    }

    public Set<Module> getAllModules(Branch branch) {
        return this.moduleFinder.find(this.resourceResolver, branch);
    }

    public Package newPackage(Package parentPackage, String packageName) {
        try {
            Package newPackage = this.resourceResolver.newPackage(parentPackage, packageName, true);
            this.newPackageEvent.fire((Object)new NewPackageEvent(newPackage));
            return newPackage;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path pathToPomXML, String newName, String comment) {
        try {
            Path projectDirectory = Paths.convert((org.uberfire.backend.vfs.Path)pathToPomXML).getParent();
            Path newModulePath = projectDirectory.resolveSibling(newName);
            POM content = (POM)this.pomService.load(pathToPomXML);
            if (newModulePath.equals(projectDirectory)) {
                return pathToPomXML;
            }
            if (this.ioService.exists(newModulePath)) {
                throw new FileAlreadyExistsException(newModulePath.toString());
            }
            org.uberfire.backend.vfs.Path oldModuleDir = Paths.convert((Path)projectDirectory);
            Object oldModule = this.resourceResolver.resolveModule(oldModuleDir);
            content.setName(newName);
            org.uberfire.backend.vfs.Path newPathToPomXML = Paths.convert((Path)newModulePath.resolve("pom.xml"));
            try {
                this.ioService.startBatch(newModulePath.getFileSystem());
                this.ioService.move(projectDirectory, newModulePath, new CopyOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
                this.pomService.save(newPathToPomXML, (Object)content, null, comment);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.ioService.endBatch();
            }
            this.invalidateDMOCache.fire((Object)new InvalidateDMOModuleCacheEvent(this.sessionInfo, oldModule, oldModuleDir));
            return newPathToPomXML;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path pathToPomXML, String comment) {
        try {
            Path projectDirectory = Paths.convert((org.uberfire.backend.vfs.Path)pathToPomXML).getParent();
            Object module2Delete = this.resourceResolver.resolveModule(Paths.convert((Path)projectDirectory));
            Optional<Path> parentPomPath = Optional.ofNullable(projectDirectory).flatMap(dir -> Optional.ofNullable(dir.getParent())).map(dir -> dir.resolve("pom.xml")).filter(pom -> this.ioService.exists(pom));
            Optional<POM> parentPom = parentPomPath.map(pom -> (POM)this.pomService.load(Paths.convert((Path)pom)));
            if (parentPomPath.isPresent() && parentPom.isPresent()) {
                this.ioService.delete(projectDirectory, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES, this.commentedOptionFactory.makeCommentedOption(comment)});
                Path pomPath = parentPomPath.get();
                POM pom2 = parentPom.get();
                pom2.setPackaging("pom");
                pom2.getModules().remove(module2Delete.getModuleName());
                this.pomService.save(Paths.convert((Path)pomPath), (Object)pom2, null, "Removing child module " + module2Delete.getModuleName());
            } else {
                Repository repo = this.repoService.getRepository(Paths.convert((Path)projectDirectory));
                this.repoService.removeRepository(repo.getSpace(), repo.getAlias());
            }
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void copy(org.uberfire.backend.vfs.Path pathToPomXML, String newName, String comment) {
        try {
            Path projectDirectory = Paths.convert((org.uberfire.backend.vfs.Path)pathToPomXML).getParent();
            Path newModulePath = projectDirectory.resolveSibling(newName);
            POM content = (POM)this.pomService.load(pathToPomXML);
            if (newModulePath.equals(projectDirectory)) {
                return;
            }
            if (this.ioService.exists(newModulePath)) {
                throw new FileAlreadyExistsException(newModulePath.toString());
            }
            content.setName(newName);
            org.uberfire.backend.vfs.Path newPathToPomXML = Paths.convert((Path)newModulePath.resolve("pom.xml"));
            try {
                this.ioService.startBatch(newModulePath.getFileSystem());
                this.ioService.copy(projectDirectory, newModulePath, new CopyOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
                this.pomService.save(newPathToPomXML, (Object)content, null, comment);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.ioService.endBatch();
            }
            Object newModule = this.resourceResolver.resolveModule(Paths.convert((Path)newModulePath));
            this.newModuleEvent.fire((Object)new NewModuleEvent(newModule, this.commentedOptionFactory.getSafeSessionId(), this.commentedOptionFactory.getSafeIdentityName()));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void reImport(org.uberfire.backend.vfs.Path pathToPomXML) {
        try {
            Path projectDirectory = Paths.convert((org.uberfire.backend.vfs.Path)pathToPomXML).getParent();
            org.uberfire.backend.vfs.Path path = Paths.convert((Path)projectDirectory);
            Object module = this.resourceResolver.resolveModule(path);
            this.invalidateDMOCache.fire((Object)new InvalidateDMOModuleCacheEvent(this.sessionInfo, module, path));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createModuleDirectories(org.uberfire.backend.vfs.Path repositoryRoot) {
        Path modulePath = Paths.convert((org.uberfire.backend.vfs.Path)repositoryRoot);
        try {
            this.ioService.startBatch(modulePath.getFileSystem(), new Option[]{this.commentedOptionFactory.makeCommentedOption("Adding module directories")});
            org.uberfire.backend.vfs.Path mainResourcesPath = Paths.convert((Path)modulePath.resolve("src/main/resources"));
            Package defaultPackage = this.resourceResolver.resolvePackage(mainResourcesPath);
            org.uberfire.backend.vfs.Path pomPath = Paths.convert((Path)modulePath.resolve("pom.xml"));
            POM modulePom = (POM)this.pomService.load(pomPath);
            String workspacePath = this.resourceResolver.getDefaultWorkspacePath(modulePom.getGav());
            this.resourceResolver.newPackage(defaultPackage, workspacePath, false);
        }
        finally {
            this.ioService.endBatch();
        }
    }
}

