/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.repositories;

import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopupView;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.shared.security.AppRoles;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
public class ConflictingRepositoriesPopup
implements ConflictingRepositoriesPopupView.Presenter {
    private User identity;
    private ConflictingRepositoriesPopupView view;

    public ConflictingRepositoriesPopup() {
    }

    @Inject
    public ConflictingRepositoriesPopup(User identity, ConflictingRepositoriesPopupView view) {
        this.identity = identity;
        this.view = view;
        view.init(this);
    }

    @Override
    public void setContent(GAV gav, Set<MavenRepositoryMetadata> metadata, Command command) {
        PortablePreconditions.checkNotNull((String)"gav", (Object)gav);
        PortablePreconditions.checkNotNull((String)"metadata", metadata);
        PortablePreconditions.checkNotNull((String)"command", (Object)command);
        this.view.setContent(gav, metadata);
        this.view.clear();
        this.view.addOKButton();
        if (this.isUserAdministrator()) {
            this.view.addOverrideButton(command);
        }
    }

    private boolean isUserAdministrator() {
        Set roles = this.identity.getRoles();
        return roles.contains(new RoleImpl(AppRoles.ADMIN.getName()));
    }

    @Override
    public void show() {
        this.view.show();
    }

    @Override
    public void hide() {
        this.view.hide();
    }
}

