/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.security;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.security.ProjectAction;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;

@ApplicationScoped
public class ProjectController {
    private AuthorizationManager authorizationManager;
    private User user;

    @Inject
    public ProjectController(AuthorizationManager authorizationManager, User user) {
        this.authorizationManager = authorizationManager;
        this.user = user;
    }

    public boolean canCreateProjects() {
        return this.authorizationManager.authorize((ResourceType)Project.RESOURCE_TYPE, (ResourceAction)ProjectAction.CREATE, this.user);
    }

    public boolean canReadProjects() {
        return this.authorizationManager.authorize((ResourceType)Project.RESOURCE_TYPE, ProjectAction.READ, this.user);
    }

    public boolean canBuildProjects() {
        return this.authorizationManager.authorize((ResourceType)Project.RESOURCE_TYPE, (ResourceAction)ProjectAction.BUILD, this.user);
    }

    public boolean canReadProject(Project repository) {
        return this.authorizationManager.authorize((Resource)repository, ProjectAction.READ, this.user);
    }

    public boolean canUpdateProject(Project repository) {
        return this.authorizationManager.authorize((Resource)repository, (ResourceAction)ProjectAction.UPDATE, this.user);
    }

    public boolean canDeleteProject(Project repository) {
        return this.authorizationManager.authorize((Resource)repository, (ResourceAction)ProjectAction.DELETE, this.user);
    }

    public boolean canBuildProject(Project repository) {
        return this.authorizationManager.authorize((Resource)repository, (ResourceAction)ProjectAction.BUILD, this.user);
    }
}

