/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.context;

import java.util.Optional;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.context.ProjectContextChangeHandle;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeHandler;
import org.guvnor.common.services.project.events.ModuleUpdatedEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceProjectContextTest {
    @Spy
    private EventSourceMock<WorkspaceProjectContextChangeEvent> changeEvent = new EventSourceMock();
    @Captor
    private ArgumentCaptor<WorkspaceProjectContextChangeEvent> previous;
    @Captor
    private ArgumentCaptor<WorkspaceProjectContextChangeEvent> next;
    private WorkspaceProjectContext context;

    @Before
    public void setUp() throws Exception {
        this.context = new WorkspaceProjectContext(this.changeEvent);
        ((EventSourceMock)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                WorkspaceProjectContextTest.this.context.onProjectContextChanged((WorkspaceProjectContextChangeEvent)invocationOnMock.getArguments()[0]);
                return null;
            }
        }).when(this.changeEvent)).fire(Matchers.any(WorkspaceProjectContextChangeEvent.class));
    }

    @Test
    public void testGetActiveRepositoryRoot() throws Exception {
        Path devRoot = (Path)Mockito.mock(Path.class);
        this.context.setActiveWorkspaceProject(new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), (Repository)Mockito.mock(Repository.class), new Branch("dev", devRoot), (Module)Mockito.mock(Module.class)));
        Assert.assertEquals(Optional.of(devRoot), (Object)this.context.getActiveRepositoryRoot());
    }

    @Test
    public void testContextChanged() throws Exception {
        OrganizationalUnit oldOrganizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        Repository oldRepository = (Repository)Mockito.mock(Repository.class);
        Package oldPackage = new Package();
        Module oldModule = new Module();
        this.context.setActiveOrganizationalUnit(oldOrganizationalUnit);
        WorkspaceProject oldProject = new WorkspaceProject(oldOrganizationalUnit, oldRepository, (Branch)Mockito.mock(Branch.class), (Module)Mockito.mock(Module.class));
        this.context.setActiveWorkspaceProject(oldProject);
        this.context.setActivePackage(oldPackage);
        this.context.setActiveModule(oldModule);
        OrganizationalUnit newOrganizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        Branch newBranch = new Branch("master", (Path)Mockito.mock(Path.class));
        Package newPackage = new Package();
        Module newModule = new Module();
        WorkspaceProjectContextChangeHandler changeHandler = (WorkspaceProjectContextChangeHandler)Mockito.mock(WorkspaceProjectContextChangeHandler.class);
        this.context.addChangeHandler(changeHandler);
        WorkspaceProject newWorkspaceProject = new WorkspaceProject(newOrganizationalUnit, (Repository)Mockito.mock(Repository.class), newBranch, (Module)Mockito.mock(Module.class));
        WorkspaceProjectContextChangeEvent event = new WorkspaceProjectContextChangeEvent(newWorkspaceProject, newModule, newPackage);
        this.context.onProjectContextChanged(event);
        Assert.assertEquals(Optional.of(newOrganizationalUnit), (Object)this.context.getActiveOrganizationalUnit());
        Assert.assertEquals(Optional.of(newWorkspaceProject), (Object)this.context.getActiveWorkspaceProject());
        Assert.assertEquals(Optional.of(newModule), (Object)this.context.getActiveModule());
        Assert.assertEquals(Optional.of(newPackage), (Object)this.context.getActivePackage());
        ((WorkspaceProjectContextChangeHandler)Mockito.verify((Object)changeHandler)).onChange((WorkspaceProjectContextChangeEvent)Matchers.eq((Object)new WorkspaceProjectContextChangeEvent(oldProject, oldModule, oldPackage)), (WorkspaceProjectContextChangeEvent)Matchers.eq((Object)event));
    }

    @Test
    public void testOnOrganizationalUnitUpdate() {
        WorkspaceProjectContextChangeHandler changeHandler = (WorkspaceProjectContextChangeHandler)Mockito.mock(WorkspaceProjectContextChangeHandler.class);
        this.context.addChangeHandler(changeHandler);
        OrganizationalUnit oldOrganizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        Repository oldRepository = (Repository)Mockito.mock(Repository.class);
        Package oldPackage = new Package();
        Module oldModule = new Module();
        WorkspaceProject oldProject = new WorkspaceProject(oldOrganizationalUnit, oldRepository, (Branch)Mockito.mock(Branch.class), (Module)Mockito.mock(Module.class));
        OrganizationalUnit newOrganizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        this.context.setActiveModule(oldModule);
        this.context.setActiveOrganizationalUnit(oldOrganizationalUnit);
        this.context.setActivePackage(oldPackage);
        this.context.setActiveWorkspaceProject(oldProject);
        UpdatedOrganizationalUnitEvent event = new UpdatedOrganizationalUnitEvent(newOrganizationalUnit, "name");
        this.context.onOrganizationalUnitUpdated(event);
        ((WorkspaceProjectContextChangeHandler)Mockito.verify((Object)changeHandler)).onChange((WorkspaceProjectContextChangeEvent)this.previous.capture(), (WorkspaceProjectContextChangeEvent)this.next.capture());
        Assert.assertEquals((Object)((WorkspaceProjectContextChangeEvent)this.previous.getValue()).getModule(), (Object)((WorkspaceProjectContextChangeEvent)this.next.getValue()).getModule());
        Assert.assertEquals((Object)((WorkspaceProjectContextChangeEvent)this.previous.getValue()).getPackage(), (Object)((WorkspaceProjectContextChangeEvent)this.next.getValue()).getPackage());
        Assert.assertNotEquals((Object)((WorkspaceProjectContextChangeEvent)this.previous.getValue()).getWorkspaceProject(), (Object)((WorkspaceProjectContextChangeEvent)this.next.getValue()).getWorkspaceProject());
        Assert.assertNotEquals((Object)((WorkspaceProjectContextChangeEvent)this.previous.getValue()).getOrganizationalUnit(), (Object)((WorkspaceProjectContextChangeEvent)this.next.getValue()).getOrganizationalUnit());
    }

    @Test
    public void testContextChangeHandlerGetsRemoved() throws Exception {
        WorkspaceProjectContextChangeHandler changeHandler = (WorkspaceProjectContextChangeHandler)Mockito.mock(WorkspaceProjectContextChangeHandler.class);
        ProjectContextChangeHandle handle = this.context.addChangeHandler(changeHandler);
        this.context.onProjectContextChanged(new WorkspaceProjectContextChangeEvent());
        ((WorkspaceProjectContextChangeHandler)Mockito.verify((Object)changeHandler)).onChange((WorkspaceProjectContextChangeEvent)Matchers.any(), (WorkspaceProjectContextChangeEvent)Matchers.eq((Object)new WorkspaceProjectContextChangeEvent()));
        this.context.removeChangeHandler(handle);
        Mockito.reset((Object[])new WorkspaceProjectContextChangeHandler[]{changeHandler});
        this.context.onProjectContextChanged(new WorkspaceProjectContextChangeEvent());
        ((WorkspaceProjectContextChangeHandler)Mockito.verify((Object)changeHandler, (VerificationMode)Mockito.never())).onChange((WorkspaceProjectContextChangeEvent)Matchers.any(), (WorkspaceProjectContextChangeEvent)Matchers.any());
    }

    @Test
    public void testNoUpdateWhenNoActiveModule() throws Exception {
        this.context.onModuleUpdated(new ModuleUpdatedEvent(this.getMockModule(), this.getMockModule()));
        ((EventSourceMock)Mockito.verify(this.changeEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
    }

    @Test
    public void testNoUpdateWhenDifferentActiveModule() throws Exception {
        Module oldModule = this.getMockModule();
        this.context.onProjectContextChanged(new WorkspaceProjectContextChangeEvent(new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), (Repository)Mockito.mock(Repository.class), (Branch)Mockito.mock(Branch.class), oldModule), oldModule));
        this.context.onModuleUpdated(new ModuleUpdatedEvent(this.getMockModule(), this.getMockModule()));
        ((EventSourceMock)Mockito.verify(this.changeEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
    }

    @Test
    public void testActiveModuleIsUpdated() throws Exception {
        Module oldModule = this.getMockModule();
        this.context.onProjectContextChanged(new WorkspaceProjectContextChangeEvent(new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), (Repository)Mockito.mock(Repository.class), (Branch)Mockito.mock(Branch.class), oldModule), oldModule));
        this.context.onModuleUpdated(new ModuleUpdatedEvent(oldModule, this.getMockModule()));
        ((EventSourceMock)Mockito.verify(this.changeEvent)).fire(Matchers.any());
    }

    private Module getMockModule() {
        return new Module((Path)Mockito.mock(Path.class), (Path)Mockito.mock(Path.class), new POM());
    }
}

