/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.ArtifactIdChangeHandler;
import org.guvnor.common.services.project.client.GAVEditorView;
import org.guvnor.common.services.project.client.GroupIdChangeHandler;
import org.guvnor.common.services.project.client.VersionChangeHandler;
import org.guvnor.common.services.project.model.GAV;

public class GAVEditor
implements GAVEditorView.Presenter,
IsWidget {
    private final GAVEditorView view;
    private GAV gav;
    private ArrayList<GroupIdChangeHandler> groupIdChangeHandlers = new ArrayList();
    private ArrayList<ArtifactIdChangeHandler> artifactIdChangeHandlers = new ArrayList();
    private ArrayList<VersionChangeHandler> versionChangeHandlers = new ArrayList();

    @Inject
    public GAVEditor(GAVEditorView view) {
        this.view = view;
        view.setPresenter(this);
    }

    @Override
    public void setGAV(GAV gav) {
        this.gav = gav;
        this.view.setGroupId(gav.getGroupId());
        this.view.setArtifactId(gav.getArtifactId());
        this.view.setVersion(gav.getVersion());
    }

    @Override
    public void setArtifactID(String artifactID) {
        this.view.setArtifactId(artifactID);
        this.gav.setArtifactId(artifactID);
    }

    @Override
    public void onGroupIdChange(String groupId) {
        this.gav.setGroupId(groupId);
        for (GroupIdChangeHandler handler : this.groupIdChangeHandlers) {
            handler.onChange(groupId);
        }
    }

    @Override
    public void onArtifactIdChange(String artifactId) {
        this.gav.setArtifactId(artifactId);
        for (ArtifactIdChangeHandler handler : this.artifactIdChangeHandlers) {
            handler.onChange(artifactId);
        }
    }

    @Override
    public void onVersionChange(String version) {
        this.gav.setVersion(version);
        for (VersionChangeHandler handler : this.versionChangeHandlers) {
            handler.onChange(version);
        }
    }

    @Override
    public void addGroupIdChangeHandler(GroupIdChangeHandler changeHandler) {
        this.groupIdChangeHandlers.add(changeHandler);
    }

    @Override
    public void addArtifactIdChangeHandler(ArtifactIdChangeHandler changeHandler) {
        this.artifactIdChangeHandlers.add(changeHandler);
    }

    @Override
    public void addVersionChangeHandler(VersionChangeHandler changeHandler) {
        this.versionChangeHandlers.add(changeHandler);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void setReadOnly() {
        this.view.setReadOnly();
    }

    @Override
    public void disableGroupID(String reason) {
        this.view.disableGroupID(reason);
    }

    @Override
    public void disableVersion(String reason) {
        this.view.disableVersion(reason);
    }

    @Override
    public void disableArtifactID(String reason) {
        this.view.disableArtifactID(reason);
    }

    @Override
    public void enableGroupID() {
        this.view.enableGroupID();
    }

    @Override
    public void enableArtifactID() {
        this.view.enableArtifactID();
    }

    @Override
    public void enableVersion() {
        this.view.enableVersion();
    }

    @Override
    public void setValidGroupID(boolean isValid) {
        this.view.setValidGroupID(isValid);
    }

    @Override
    public void setValidArtifactID(boolean isValid) {
        this.view.setValidArtifactID(isValid);
    }

    @Override
    public void setValidVersion(boolean isValid) {
        this.view.setValidVersion(isValid);
    }
}

