/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.security;

import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.security.ProjectPermissionsService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.RolePermissions;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.security.RepositoryAction;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.promise.Promises;
import org.uberfire.security.Contributor;
import org.uberfire.security.ContributorType;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

@ApplicationScoped
public class ProjectController {
    private AuthorizationManager authorizationManager;
    private User user;
    private Caller<ProjectPermissionsService> projectPermissionsService;
    private Promises promises;
    private static final String SHOW_PROJECT_TOOLBAR = "projecttoolbar.show";
    private static final String SHOW_METRICS_TAB = "metricstab.show";
    private static final String SHOW_CHANGEREQUEST_TAB = "changerequesttab.show";

    @Inject
    public ProjectController(AuthorizationManager authorizationManager, User user, Caller<ProjectPermissionsService> projectPermissionsService, Promises promises) {
        this.authorizationManager = authorizationManager;
        this.user = user;
        this.projectPermissionsService = projectPermissionsService;
        this.promises = promises;
    }

    public boolean canViewProjectToolbar() {
        return this.authorizationManager.authorize(SHOW_PROJECT_TOOLBAR, this.user);
    }

    public boolean canViewMetricsTab() {
        return this.authorizationManager.authorize(SHOW_METRICS_TAB, this.user);
    }

    public boolean canViewChangeRequestTab() {
        return this.authorizationManager.authorize(SHOW_CHANGEREQUEST_TAB, this.user);
    }

    public boolean canCreateProjects(OrganizationalUnit organizationalUnit) {
        boolean securityPermission = this.authorizationManager.authorize((ResourceType)Repository.RESOURCE_TYPE, (ResourceAction)RepositoryAction.CREATE, this.user);
        return securityPermission || this.userIsAtLeast(ContributorType.CONTRIBUTOR, organizationalUnit.getContributors());
    }

    public boolean canReadProject(WorkspaceProject workspaceProject) {
        boolean securityPermission = this.authorizationManager.authorize((Resource)workspaceProject.getRepository(), RepositoryAction.READ, this.user);
        return securityPermission || this.userIsAtLeast(ContributorType.OWNER, workspaceProject.getOrganizationalUnit().getContributors()) || this.userIsAtLeast(ContributorType.CONTRIBUTOR, workspaceProject.getRepository().getContributors());
    }

    public Promise<Boolean> canUpdateProject(WorkspaceProject workspaceProject) {
        return this.canUpdateBranch(workspaceProject, workspaceProject.getBranch());
    }

    public Promise<Boolean> canUpdateBranch(WorkspaceProject workspaceProject, Branch branch) {
        if (workspaceProject.getMainModule() == null) {
            return this.promises.resolve((Object)false);
        }
        if (this.authorizationManager.authorize((Resource)workspaceProject.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user)) {
            return this.promises.resolve((Object)true);
        }
        return this.checkBranchPermission(workspaceProject, branch.getName(), RolePermissions::canWrite);
    }

    public boolean canDeleteProject(WorkspaceProject workspaceProject) {
        boolean securityPermission = this.authorizationManager.authorize((Resource)workspaceProject.getRepository(), (ResourceAction)RepositoryAction.DELETE, this.user);
        return securityPermission || this.userIsAtLeast(ContributorType.OWNER, workspaceProject.getRepository().getContributors()) || this.userIsAtLeast(ContributorType.OWNER, workspaceProject.getOrganizationalUnit().getContributors());
    }

    public Promise<Boolean> canBuildProject(WorkspaceProject workspaceProject) {
        if (workspaceProject.getMainModule() == null) {
            return this.promises.resolve((Object)false);
        }
        if (this.authorizationManager.authorize((Resource)workspaceProject.getRepository(), (ResourceAction)RepositoryAction.BUILD, this.user)) {
            return this.promises.resolve((Object)true);
        }
        return this.checkBranchPermission(workspaceProject, workspaceProject.getBranch().getName(), RolePermissions::canWrite);
    }

    public Promise<Boolean> canDeployProject(WorkspaceProject workspaceProject) {
        if (workspaceProject.getMainModule() == null) {
            return this.promises.resolve((Object)false);
        }
        if (this.authorizationManager.authorize((Resource)workspaceProject.getRepository(), (ResourceAction)RepositoryAction.BUILD, this.user)) {
            return this.promises.resolve((Object)true);
        }
        return this.checkBranchPermission(workspaceProject, workspaceProject.getBranch().getName(), RolePermissions::canDeploy);
    }

    public Promise<Boolean> canReadBranch(WorkspaceProject project) {
        return this.canReadBranch(project, project.getBranch().getName());
    }

    public Promise<Boolean> canReadBranch(WorkspaceProject project, String branch) {
        if (this.authorizationManager.authorize((Resource)project.getRepository(), RepositoryAction.READ, this.user)) {
            return this.promises.resolve((Object)true);
        }
        return this.checkBranchPermission(project, branch, RolePermissions::canRead);
    }

    public Promise<Boolean> canDeleteBranch(WorkspaceProject project) {
        return this.canDeleteBranch(project, project.getBranch().getName());
    }

    public Promise<Boolean> canSubmitChangeRequest(WorkspaceProject project) {
        return this.canSubmitChangeRequest(project, project.getBranch().getName());
    }

    public Promise<Boolean> canDeleteBranch(WorkspaceProject project, String branch) {
        if (project.getBranch().getName().equals("master")) {
            return this.promises.resolve((Object)false);
        }
        if (this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.DELETE, this.user)) {
            return this.promises.resolve((Object)true);
        }
        return this.checkBranchPermission(project, branch, RolePermissions::canDelete);
    }

    public Promise<Boolean> canViewDeploymentDetails(String id) {
        ResourceRef resourceRef = new ResourceRef(id, (ResourceType)ActivityResourceType.PERSPECTIVE);
        Boolean authorized = this.authorizationManager.authorize((Resource)resourceRef, this.user);
        return this.promises.resolve((Object)authorized);
    }

    public Promise<Boolean> canSubmitChangeRequest(WorkspaceProject project, String branch) {
        if (project.getBranch().getName().equals("master")) {
            return this.promises.resolve((Object)false);
        }
        if (this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user)) {
            return this.promises.resolve((Object)true);
        }
        return this.checkBranchPermission(project, branch, RolePermissions::canRead);
    }

    boolean userIsAtLeast(ContributorType type, Collection<Contributor> contributors) {
        return contributors.stream().anyMatch(c -> c.getUsername().equals(this.user.getIdentifier()) && ContributorType.PRIORITY_ORDER.indexOf(c.getType()) <= ContributorType.PRIORITY_ORDER.indexOf(type));
    }

    Optional<Contributor> getUserContributor(Collection<Contributor> contributors) {
        return contributors.stream().filter(c -> c.getUsername().equals(this.user.getIdentifier())).findFirst();
    }

    Promise<Boolean> checkBranchPermission(WorkspaceProject project, String branch, Function<RolePermissions, Boolean> rolePermissionsCheck) {
        return this.getBranchPermissionsForUser(project, branch).then(rolePermissions -> {
            if (rolePermissions.isPresent()) {
                return this.promises.resolve((Object)((Boolean)rolePermissionsCheck.apply((RolePermissions)rolePermissions.get())));
            }
            return this.promises.resolve((Object)false);
        });
    }

    public Promise<Optional<RolePermissions>> getBranchPermissionsForUser(WorkspaceProject project, String branch) {
        return this.promises.promisify(this.projectPermissionsService, s -> s.loadBranchPermissions(project.getSpace().getName(), project.getRepository().getIdentifier(), branch)).then(branchPermissions -> this.promises.resolve(this.getBranchPermissionsForUser(project, branchPermissions.getPermissionsByRole())));
    }

    public Optional<RolePermissions> getBranchPermissionsForUser(WorkspaceProject project, Map<String, RolePermissions> permissionsByRole) {
        RolePermissions rolePermissions;
        Optional<Contributor> userContributor = this.getUserContributor(project.getRepository().getContributors());
        if (userContributor.isPresent() && (rolePermissions = permissionsByRole.get(userContributor.get().getType().name())) != null) {
            return Optional.of(rolePermissions);
        }
        return Optional.empty();
    }

    public Promise<List<Branch>> getReadableBranches(WorkspaceProject project) {
        if (project.getMainModule() == null) {
            return this.promises.resolve(Collections.emptyList());
        }
        if (this.authorizationManager.authorize((Resource)project.getRepository(), RepositoryAction.READ, this.user)) {
            return this.promises.resolve(new ArrayList(project.getRepository().getBranches()));
        }
        return this.getBranchesWithPermission(project, RolePermissions::canRead);
    }

    public Promise<List<Branch>> getUpdatableBranches(WorkspaceProject project) {
        if (project.getMainModule() == null) {
            return this.promises.resolve(Collections.emptyList());
        }
        if (this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user)) {
            return this.promises.resolve(new ArrayList(project.getRepository().getBranches()));
        }
        return this.getBranchesWithPermission(project, RolePermissions::canWrite);
    }

    private Promise<List<Branch>> getBranchesWithPermission(WorkspaceProject project, Function<RolePermissions, Boolean> rolePermissionsCheck) {
        return this.promises.promisify(this.projectPermissionsService, service -> service.loadBranchPermissions(project.getSpace().getName(), project.getRepository().getIdentifier(), project.getRepository().getBranches().stream().map(Branch::getName).collect(Collectors.toList()))).then(branchPermissions -> this.promises.resolve(project.getRepository().getBranches().stream().filter(branch -> {
            Optional<RolePermissions> branchPermissionsForUser = this.getBranchPermissionsForUser(project, ((BranchPermissions)branchPermissions.get(branch.getName())).getPermissionsByRole());
            return branchPermissionsForUser.map(rolePermissionsCheck).orElse(false);
        }).collect(Collectors.toList())));
    }
}

