/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.repositories;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopupView;
import org.guvnor.common.services.project.client.resources.ProjectResources;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;

public class ConflictingRepositoriesPopupViewImpl
extends BaseModal
implements ConflictingRepositoriesPopupView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    Heading header;
    @UiField(provided=true)
    CellTable<MavenRepositoryMetadata> table = new CellTable();
    private final GenericModalFooter footer = new GenericModalFooter();
    private ConflictingRepositoriesPopupView.Presenter presenter;
    private List<MavenRepositoryMetadata> repositories = new ArrayList<MavenRepositoryMetadata>();
    private ListDataProvider<MavenRepositoryMetadata> dataProvider = new ListDataProvider();
    TextColumn<MavenRepositoryMetadata> repositoryIdColumn;
    TextColumn<MavenRepositoryMetadata> repositoryUrlColumn;
    TextColumn<MavenRepositoryMetadata> repositorySourceColumn;

    public ConflictingRepositoriesPopupViewImpl() {
        this.setTitle(ProjectResources.CONSTANTS.ConflictingRepositoriesTitle());
        this.setBody((Widget)uiBinder.createAndBindUi(this));
        this.add((Widget)this.footer);
        this.setup();
    }

    private void setup() {
        this.table.setStriped(true);
        this.table.setCondensed(true);
        this.table.setBordered(true);
        this.repositoryIdColumn = new TextColumn<MavenRepositoryMetadata>(){

            public String getValue(MavenRepositoryMetadata metadata) {
                return metadata.getId();
            }
        };
        this.repositoryUrlColumn = new TextColumn<MavenRepositoryMetadata>(){

            public String getValue(MavenRepositoryMetadata metadata) {
                return metadata.getUrl();
            }
        };
        this.repositorySourceColumn = new TextColumn<MavenRepositoryMetadata>(){

            public String getValue(MavenRepositoryMetadata metadata) {
                switch (metadata.getSource()) {
                    case LOCAL: {
                        return ProjectResources.CONSTANTS.RepositorySourceLocal();
                    }
                    case PROJECT: {
                        return ProjectResources.CONSTANTS.RepositorySourceProject();
                    }
                    case SETTINGS: {
                        return ProjectResources.CONSTANTS.RepositorySourceSettings();
                    }
                    case DISTRIBUTION_MANAGEMENT: {
                        return ProjectResources.CONSTANTS.RepositorySourceDistributionManagement();
                    }
                }
                return ProjectResources.CONSTANTS.RepositorySourceUnknown();
            }
        };
        this.table.addColumn(this.repositoryIdColumn, (Header)new TextHeader(ProjectResources.CONSTANTS.RepositoryId()));
        this.table.addColumn(this.repositoryUrlColumn, (Header)new TextHeader(ProjectResources.CONSTANTS.RepositoryUrl()));
        this.table.addColumn(this.repositorySourceColumn, (Header)new TextHeader(ProjectResources.CONSTANTS.RepositorySource()));
        this.dataProvider.addDataDisplay(this.table);
        this.dataProvider.setList(this.repositories);
    }

    public void init(ConflictingRepositoriesPopupView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void clear() {
        this.footer.clear();
    }

    @Override
    public void setContent(GAV gav, Set<MavenRepositoryMetadata> repositories) {
        this.repositories = this.sortRepositories(repositories);
        this.dataProvider.setList(this.repositories);
        this.header.setText(ProjectResources.CONSTANTS.ConflictingRepositoriesGAVDescription(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()));
    }

    private List<MavenRepositoryMetadata> sortRepositories(Set<MavenRepositoryMetadata> repositories) {
        ArrayList<MavenRepositoryMetadata> sortedRepositories = new ArrayList<MavenRepositoryMetadata>();
        sortedRepositories.addAll(repositories);
        Collections.sort(sortedRepositories, (md1, md2) -> {
            if (md1.getSource().equals((Object)md2.getSource())) {
                return md1.getId().compareToIgnoreCase(md2.getId());
            }
            return md1.getSource().ordinal() - md2.getSource().ordinal();
        });
        return sortedRepositories;
    }

    @Override
    public void addOKButton() {
        this.footer.addButton(CommonConstants.INSTANCE.OK(), this.presenter::hide, IconType.PLUS, ButtonType.PRIMARY);
    }

    @Override
    public void addOverrideButton() {
        this.footer.addButton(ProjectResources.CONSTANTS.ConflictingRepositoriesOverride(), this.presenter::override, ButtonType.DEFAULT);
    }

    static interface Binder
    extends UiBinder<Widget, ConflictingRepositoriesPopupViewImpl> {
    }
}

