/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.net.URI;
import java.util.HashSet;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.MavenRepositorySource;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.rest.backend.JobRequestHelper;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class JobRequestHelperCreateProjectTest {
    public SimpleFileSystemProvider fileSystemProvider;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private ProjectService<? extends Project> projectService;
    @InjectMocks
    private JobRequestHelper jobRequestHelper = new JobRequestHelper();

    @Before
    public void setUp() throws Exception {
        this.fileSystemProvider = new SimpleFileSystemProvider();
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)this.repositoryService.getRepository("myRepository")).thenReturn((Object)repository);
        Mockito.when((Object)repository.getDefaultBranch()).thenReturn((Object)"master");
        Path root = this.fileSystemProvider.getPath(URI.create("default://master@myRepository/"));
        Mockito.when((Object)repository.getBranchRoot("master")).thenReturn((Object)Paths.convert((Path)root));
    }

    @Test
    public void testRepositoryDoesNotExist() throws Exception {
        JobResult jobResult = this.jobRequestHelper.createProject("jobId", "repositoryAlias", "projectName", "projectGroupId", "projectVersion", "projectDescription");
        Assert.assertEquals((Object)"jobId", (Object)jobResult.getJobId());
        Assert.assertEquals((Object)JobStatus.RESOURCE_NOT_EXIST, (Object)jobResult.getStatus());
        Assert.assertEquals((Object)"Repository [repositoryAlias] does not exist", (Object)jobResult.getResult());
    }

    @Test
    public void testRepositoryDoesExist() throws Exception {
        JobResult jobResult = this.jobRequestHelper.createProject("jobId", "myRepository", "projectName", "projectGroupId", "projectVersion", "projectDescription");
        Assert.assertEquals((Object)"jobId", (Object)jobResult.getJobId());
        Assert.assertEquals((Object)JobStatus.SUCCESS, (Object)jobResult.getStatus());
        Assert.assertNull((Object)jobResult.getResult());
    }

    @Test
    public void testNewProjectWhenGAVAlreadyExists() throws Exception {
        HashSet<MavenRepositoryMetadata> repositories = new HashSet<MavenRepositoryMetadata>();
        repositories.add(new MavenRepositoryMetadata("id", "url", MavenRepositorySource.LOCAL));
        ((ProjectService)Mockito.doThrow((Throwable)new GAVAlreadyExistsException(new GAV("projectGroupId:projectName:projectVersion"), repositories)).when(this.projectService)).newProject((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (POM)Mockito.any(POM.class), (String)Mockito.eq((Object)"/"));
        JobResult jobResult = this.jobRequestHelper.createProject("jobId", "myRepository", "projectName", "projectGroupId", "projectVersion", "projectDescription");
        Assert.assertEquals((Object)"jobId", (Object)jobResult.getJobId());
        Assert.assertEquals((Object)JobStatus.DUPLICATE_RESOURCE, (Object)jobResult.getStatus());
        Assert.assertEquals((Object)"Project's GAV [projectGroupId:projectName:projectVersion] already exists at [id : url : LOCAL ]", (Object)jobResult.getResult());
    }

    @Test
    public void testNewProjectWhenFileAlreadyExists() throws Exception {
        ((ProjectService)Mockito.doThrow((Throwable)new FileAlreadyExistsException("myProject")).when(this.projectService)).newProject((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (POM)Mockito.any(POM.class), (String)Mockito.eq((Object)"/"));
        JobResult jobResult = this.jobRequestHelper.createProject("jobId", "myRepository", "myProject", "projectGroupId", "projectVersion", "projectDescription");
        Assert.assertEquals((Object)"jobId", (Object)jobResult.getJobId());
        Assert.assertEquals((Object)JobStatus.DUPLICATE_RESOURCE, (Object)jobResult.getStatus());
        Assert.assertEquals((Object)"Project [myProject] already exists", (Object)jobResult.getResult());
    }

    @Test
    public void testWeAreUsingCorrectGAV() throws Exception {
        this.jobRequestHelper.createProject("jobId", "myRepository", "myProject", "projectGroupId", "projectVersion", "projectDescription");
        ArgumentCaptor pomArgumentCaptor = ArgumentCaptor.forClass(POM.class);
        ((ProjectService)Mockito.verify(this.projectService)).newProject((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (POM)pomArgumentCaptor.capture(), (String)Mockito.eq((Object)"/"));
        POM pom = (POM)pomArgumentCaptor.getValue();
        Assert.assertEquals((Object)"projectGroupId", (Object)pom.getGav().getGroupId());
        Assert.assertEquals((Object)"myProject", (Object)pom.getGav().getArtifactId());
        Assert.assertEquals((Object)"projectVersion", (Object)pom.getGav().getVersion());
        Assert.assertEquals((Object)"myProject", (Object)pom.getName());
        Assert.assertEquals((Object)"projectDescription", (Object)pom.getDescription());
    }

    @Test
    public void testProjectGroupNull() throws Exception {
        this.jobRequestHelper.createProject("jobId", "myRepository", "myProject", null, "projectVersion", "projectDescription");
        ArgumentCaptor pomArgumentCaptor = ArgumentCaptor.forClass(POM.class);
        ((ProjectService)Mockito.verify(this.projectService)).newProject((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (POM)pomArgumentCaptor.capture(), (String)Mockito.eq((Object)"/"));
        POM pom = (POM)pomArgumentCaptor.getValue();
        Assert.assertEquals((Object)"myProject", (Object)pom.getGav().getGroupId());
    }

    @Test
    public void testProjectGroupEmpty() throws Exception {
        this.jobRequestHelper.createProject("jobId", "myRepository", "myProject", "             ", "projectVersion", "projectDescription");
        ArgumentCaptor pomArgumentCaptor = ArgumentCaptor.forClass(POM.class);
        ((ProjectService)Mockito.verify(this.projectService)).newProject((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (POM)pomArgumentCaptor.capture(), (String)Mockito.eq((Object)"/"));
        POM pom = (POM)pomArgumentCaptor.getValue();
        Assert.assertEquals((Object)"myProject", (Object)pom.getGav().getGroupId());
    }

    @Test
    public void testProjectVersionNull() throws Exception {
        this.jobRequestHelper.createProject("jobId", "myRepository", "myProject", "projectGroupId", null, "projectDescription");
        ArgumentCaptor pomArgumentCaptor = ArgumentCaptor.forClass(POM.class);
        ((ProjectService)Mockito.verify(this.projectService)).newProject((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (POM)pomArgumentCaptor.capture(), (String)Mockito.eq((Object)"/"));
        POM pom = (POM)pomArgumentCaptor.getValue();
        Assert.assertEquals((Object)"1.0", (Object)pom.getGav().getVersion());
    }

    @Test
    public void testProjectVersionEmpty() throws Exception {
        this.jobRequestHelper.createProject("jobId", "myRepository", "myProject", "projectGroupId", "               ", "projectDescription");
        ArgumentCaptor pomArgumentCaptor = ArgumentCaptor.forClass(POM.class);
        ((ProjectService)Mockito.verify(this.projectService)).newProject((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (POM)pomArgumentCaptor.capture(), (String)Mockito.eq((Object)"/"));
        POM pom = (POM)pomArgumentCaptor.getValue();
        Assert.assertEquals((Object)"1.0", (Object)pom.getGav().getVersion());
    }
}

