/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.ArrayList;
import java.util.Collections;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.common.services.shared.test.TestService;
import org.guvnor.rest.backend.JobRequestHelper;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class JobRequestHelperTest {
    @InjectMocks
    JobRequestHelper helper;
    @Mock
    Repository repository;
    @Captor
    ArgumentCaptor<Event<TestResultMessage>> captor;
    @Mock
    private TestService testService;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private ProjectService<MyProject> projectService;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.repositoryService.getRepository("repositoryAlias")).thenReturn((Object)this.repository);
    }

    @Test
    public void resourceDoesNotExist() throws Exception {
        JobResult jobResult = this.helper.testProject(null, "repositoryAlias", null);
        Assert.assertEquals((Object)JobStatus.RESOURCE_NOT_EXIST, (Object)jobResult.getStatus());
    }

    @Test
    public void projectDoesNotExist() throws Exception {
        Mockito.when((Object)this.repository.getDefaultBranch()).thenReturn((Object)"master");
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://project/");
        Mockito.when((Object)this.repository.getBranchRoot("master")).thenReturn((Object)path);
        JobResult jobResult = this.helper.testProject(null, "repositoryAlias", "project");
        Assert.assertEquals((Object)JobStatus.RESOURCE_NOT_EXIST, (Object)jobResult.getStatus());
    }

    @Test
    public void allTestsPass() throws Exception {
        this.whenProjectExists();
        this.thenExpectMessageWithStatus(new TestResultMessage("JobRequestHelper", 10, 1000L, Collections.emptyList()), JobStatus.SUCCESS);
    }

    @Test
    public void testsFail() throws Exception {
        this.whenProjectExists();
        ArrayList<Failure> failures = new ArrayList<Failure>();
        failures.add(new Failure());
        this.thenExpectMessageWithStatus(new TestResultMessage("JobRequestHelper", 10, 1000L, failures), JobStatus.FAIL);
    }

    private void thenExpectMessageWithStatus(TestResultMessage message, JobStatus status) {
        JobResult jobResult = this.helper.testProject(null, "repositoryAlias", "project");
        ((TestService)Mockito.verify((Object)this.testService)).runAllTests((String)Matchers.eq((Object)"JobRequestHelper"), (Path)Matchers.any(Path.class), (Event)this.captor.capture());
        ((Event)this.captor.getValue()).fire((Object)message);
        Assert.assertEquals((Object)status, (Object)jobResult.getStatus());
    }

    private void whenProjectExists() {
        Mockito.when((Object)this.repository.getDefaultBranch()).thenReturn((Object)"master");
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://project/");
        Mockito.when((Object)this.repository.getBranchRoot("master")).thenReturn((Object)path);
        Mockito.when((Object)this.projectService.resolveProject((Path)Matchers.any(Path.class))).thenReturn(Mockito.mock(MyProject.class));
    }

    class MyProject
    extends Project {
        MyProject() {
        }
    }
}

