/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.rest.backend.JobRequestScheduler;
import org.guvnor.rest.backend.JobResultManager;
import org.guvnor.rest.backend.ProjectResource;
import org.guvnor.rest.client.AddBranchRequest;
import org.guvnor.rest.client.CloneProjectRequest;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.Space;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class ProjectResourceJobTest {
    @Mock
    private SpacesAPI spacesAPI;
    @Mock
    private JobResultManager jobManager;
    @Mock
    private JobRequestScheduler jobRequestObserver;
    @Mock
    private OrganizationalUnitService organizationalUnitService;
    @Mock
    private WorkspaceProjectService workspaceProjectService;
    @Mock
    private SessionInfo sessionInfo;
    @Captor
    private ArgumentCaptor<JobResult> jobResultArgumentCaptor;
    @InjectMocks
    ProjectResource projectResource = new ProjectResource(){

        protected Variant getDefaultVariant() {
            return null;
        }

        protected void assertObjectExists(Object o, String objectInfo, String objectName) {
        }

        protected Response createAcceptedStatusResponse(JobRequest jobRequest) {
            return null;
        }
    };

    @Before
    public void setup() {
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user");
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)user);
    }

    @Test
    public void cloneProject() throws Exception {
        this.projectResource.cloneProject("spaceName", new CloneProjectRequest());
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void createProject() throws Exception {
        this.projectResource.createProject("spaceName", new CreateProjectRequest());
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void deleteProject() throws Exception {
        this.projectResource.deleteProject("spaceName", "projectName");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void compileProject() throws Exception {
        this.projectResource.compileProject("spaceName", "projectName");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void compileProjectNullBranch() throws Exception {
        this.projectResource.compileProject("spaceName", "projectName", null);
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void compileProjectMasterBranch() throws Exception {
        this.projectResource.compileProject("spaceName", "projectName", "master");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void compileProjectNonExistingBranch() throws Exception {
        this.projectResource.compileProject("spaceName", "projectName", "branch123");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void installProject() throws Exception {
        this.projectResource.installProject("spaceName", "projectName");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void installProjectNullBranch() throws Exception {
        this.projectResource.installProject("spaceName", "projectName", null);
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void installProjectMasterBranch() throws Exception {
        this.projectResource.installProject("spaceName", "projectName", "master");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void installProjectNonExistingBranch() throws Exception {
        this.projectResource.installProject("spaceName", "projectName", "branch123");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void testProject() throws Exception {
        this.projectResource.testProject("spaceName", "projectName");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void testProjectNullBranch() throws Exception {
        this.projectResource.testProject("spaceName", "projectName", null);
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void testProjectMasterBranch() throws Exception {
        this.projectResource.testProject("spaceName", "projectName", "master");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void testProjectNonExisting() throws Exception {
        this.projectResource.testProject("spaceName", "projectName", "branch123");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void deployProject() throws Exception {
        this.projectResource.deployProject("spaceName", "projectName");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void deployProjectNullBranch() throws Exception {
        this.projectResource.deployProject("spaceName", "projectName", null);
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void deployProjectMasterBranch() throws Exception {
        this.projectResource.deployProject("spaceName", "projectName", "master");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void deployProjectNonExistingBranch() throws Exception {
        this.projectResource.deployProject("spaceName", "projectName", "branch123");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void createSpace() throws Exception {
        this.projectResource.createSpace(new Space());
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void updateSpace() throws Exception {
        this.projectResource.updateSpace(new Space());
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void deleteSpace() throws Exception {
        this.projectResource.deleteSpace("spaceName");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void addBranch() {
        this.projectResource.addBranch("spaceName", "projectName", new AddBranchRequest());
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }

    @Test
    public void removeBranch() {
        this.projectResource.removeBranch("spaceName", "projectName", "branchName");
        ((JobResultManager)Mockito.verify((Object)this.jobManager)).putJob((JobResult)this.jobResultArgumentCaptor.capture());
        Assert.assertEquals((Object)JobStatus.ACCEPTED, (Object)((JobResult)this.jobResultArgumentCaptor.getValue()).getStatus());
    }
}

