/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.guvnor.rest.backend.UserManagementResourceHelper;
import org.guvnor.rest.client.NewGroup;
import org.guvnor.rest.client.NewUser;
import org.guvnor.rest.client.PermissionResponse;
import org.guvnor.rest.client.UberfireRestResponse;
import org.guvnor.rest.client.UpdateSettingRequest;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.annotations.Customizable;
import org.uberfire.ext.security.management.api.service.GroupManagerService;
import org.uberfire.ext.security.management.api.service.RoleManagerService;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.workbench.model.AppFormerActivities;

@Path(value="/")
@Named
@ApplicationScoped
public class UserManagementResource {
    private static final Logger logger = LoggerFactory.getLogger(UserManagementResource.class);
    @Inject
    private GroupManagerService groupManagerService;
    @Inject
    private RoleManagerService roleManagerService;
    @Inject
    private UserManagerService userManagerService;
    @Inject
    private UserManagementResourceHelper resourceHelper;
    @Inject
    @Customizable
    private AppFormerActivities appFormerActivities;
    private Variant defaultVariant = this.getDefaultVariant();

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/groups")
    @RolesAllowed(value={"admin"})
    public Response createGroup(NewGroup group) {
        logger.debug("-----createGroup--- , Group name: {}, User assigned : {}", (Object)group.getName(), (Object)group.getUsers());
        UberfireRestResponse response = this.resourceHelper.createGroup(group.getName(), group.getUsers());
        return this.createResponse(response);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/users")
    @RolesAllowed(value={"admin"})
    public Response createUser(NewUser newUser) {
        logger.debug("-----createUsers--- , User name: {}", (Object)newUser.getName());
        UberfireRestResponse response = this.resourceHelper.createUser(newUser);
        return this.createResponse(response);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/users/{userName}/changePassword")
    @RolesAllowed(value={"admin"})
    public Response changePassword(@PathParam(value="userName") String userName, String password) {
        logger.debug("-----changePassword--- , User name: {}", (Object)userName);
        this.assertObjectExists(this.userManagerService.get(userName), "user", userName);
        UberfireRestResponse response = this.resourceHelper.changePassword(userName, password);
        return this.createResponse(response);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/groups/{groupName}")
    @RolesAllowed(value={"admin"})
    public Response deleteGroup(@PathParam(value="groupName") String groupName) {
        logger.debug("-----deleteGroup--- , Group Name: {}", (Object)groupName);
        this.assertObjectExists(this.groupManagerService.get(groupName), "group", groupName);
        UberfireRestResponse response = this.resourceHelper.removeGroup(groupName);
        return this.createResponse(response);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/users/{userName}")
    @RolesAllowed(value={"admin"})
    public Response deleteUser(@PathParam(value="userName") String userName) {
        logger.debug("-----deleteUser--- , User Name: {}", (Object)userName);
        this.assertObjectExists(this.userManagerService.get(userName), "user", userName);
        UberfireRestResponse response = this.resourceHelper.removeUser(userName);
        return this.createResponse(response);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/groups/{groupName}/permissions")
    @RolesAllowed(value={"admin"})
    public Response updateGroupPermissions(@PathParam(value="groupName") String groupName, UpdateSettingRequest permissionRequest) {
        logger.debug("-----updateGroupPermissions--- , Group name: {}", (Object)groupName);
        this.assertObjectExists(this.groupManagerService.get(groupName), "group", groupName);
        UberfireRestResponse response = this.resourceHelper.updateGroupPermissions(groupName, permissionRequest);
        return this.createResponse(response);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/roles/{rolesName}/permissions")
    @RolesAllowed(value={"admin"})
    public Response updateRolePermissions(@PathParam(value="rolesName") String rolesName, UpdateSettingRequest permissionRequest) {
        logger.debug("-----updateRolePermissions--- , Role name: {}", (Object)rolesName);
        this.assertObjectExists(this.roleManagerService.get(rolesName), "role", rolesName);
        UberfireRestResponse response = this.resourceHelper.updateRolePermissions(rolesName, permissionRequest);
        return this.createResponse(response);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/users/{userName}/groups")
    @RolesAllowed(value={"admin"})
    public Response assignGroupsToUser(@PathParam(value="userName") String userName, List<String> groups) {
        logger.debug("-----assignGroupsToUser--- , User name: {}", (Object)userName);
        this.assertObjectExists(this.userManagerService.get(userName), "user", userName);
        UberfireRestResponse response = this.resourceHelper.assignGroupsToUser(userName, groups);
        return this.createResponse(response);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/users/{userName}/roles")
    @RolesAllowed(value={"admin"})
    public Response assignRolesToUser(@PathParam(value="userName") String userName, List<String> roles) {
        logger.debug("-----assignRolesToUser--- , User name: {}", (Object)userName);
        this.assertObjectExists(this.userManagerService.get(userName), "user", userName);
        UberfireRestResponse response = this.resourceHelper.assignRolesToUser(userName, roles);
        return this.createResponse(response);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/users/{userName}/permissions")
    @RolesAllowed(value={"admin"})
    public PermissionResponse getUserPermissions(@PathParam(value="userName") String userName) {
        logger.debug("-----getUserPermissions--- ");
        User user = this.userManagerService.getUser(userName);
        this.assertObjectExists(user, "user", userName);
        return this.resourceHelper.getUserPermissions(userName);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/groups/{groupName}/permissions")
    @RolesAllowed(value={"admin"})
    public PermissionResponse getGroupPermissions(@PathParam(value="groupName") String groupName) {
        logger.debug("-----getGroupPermissions--- ");
        Group group = (Group)this.groupManagerService.get(groupName);
        this.assertObjectExists(group, "group", groupName);
        return this.resourceHelper.getGroupPermissions(groupName);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/roles/{roleName}/permissions")
    @RolesAllowed(value={"admin"})
    public PermissionResponse getRolePermissions(@PathParam(value="roleName") String roleName) {
        logger.debug("-----getUserPermissions--- ");
        Role role = (Role)this.roleManagerService.get(roleName);
        this.assertObjectExists(role, "role", roleName);
        return this.resourceHelper.getRolePermissions(roleName);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/roles")
    @RolesAllowed(value={"admin"})
    public Collection<Role> getRoles() {
        logger.debug("-----getRoles--- ");
        return this.roleManagerService.getAll();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/users")
    @RolesAllowed(value={"admin"})
    public Collection<String> getUsers() {
        logger.debug("-----getUsers--- ");
        ArrayList<String> results = new ArrayList<String>();
        List users = this.userManagerService.getAll();
        if (users != null) {
            for (User user : users) {
                results.add(user.getIdentifier());
            }
        }
        return results;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/users/{userName}/groups")
    @RolesAllowed(value={"admin"})
    public Collection<Group> getUserGroups(@PathParam(value="userName") String userName) {
        logger.debug("-----getUserGroups--- ");
        User user = this.userManagerService.getUser(userName);
        this.assertObjectExists(user, "user", userName);
        return user.getGroups();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/users/{userName}/roles")
    @RolesAllowed(value={"admin"})
    public Collection<Role> getUserRoles(@PathParam(value="userName") String userName) {
        logger.debug("-----getUserRoles--- ");
        User user = this.userManagerService.getUser(userName);
        this.assertObjectExists(user, "user", userName);
        return user.getRoles();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/groups")
    @RolesAllowed(value={"admin"})
    public Collection<Group> getGroups() {
        logger.debug("-----getGroups--- ");
        return this.groupManagerService.getAll();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/editors")
    @RolesAllowed(value={"admin"})
    public Collection<String> getEditors() {
        logger.debug("-----getEditors--- ");
        return this.appFormerActivities.getAllEditorIds();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/perspectives")
    @RolesAllowed(value={"admin"})
    public Collection<String> getPerpectives() {
        logger.debug("-----getPerpectives--- ");
        return this.appFormerActivities.getAllPerpectivesIds();
    }

    protected void assertObjectExists(Object o, String objectInfo, String objectName) {
        if (o == null) {
            throw new WebApplicationException(String.format("Could not find %s with name %s.", objectInfo, objectName), Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
    }

    protected Response createResponse(UberfireRestResponse restResponse) {
        return Response.status((Response.Status)restResponse.getStatus()).entity((Object)restResponse).variant(this.defaultVariant).build();
    }

    protected Variant getDefaultVariant() {
        return (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).add().build().get(0);
    }
}

