/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.assertj.core.api.Assertions;
import org.guvnor.rest.backend.UserManagementResource;
import org.guvnor.rest.backend.UserManagementResourceHelper;
import org.guvnor.rest.client.NewGroup;
import org.guvnor.rest.client.NewUser;
import org.guvnor.rest.client.UberfireRestResponse;
import org.guvnor.rest.client.UpdateSettingRequest;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Lists;
import org.kie.soup.commons.util.Sets;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.security.management.api.service.GroupManagerService;
import org.uberfire.ext.security.management.api.service.RoleManagerService;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.workbench.model.AppFormerActivities;

@RunWith(value=MockitoJUnitRunner.class)
public class UserManagementResourceJobTest {
    @Mock
    private GroupManagerService groupManagerService;
    @Mock
    private RoleManagerService roleManagerService;
    @Mock
    private UserManagerService userManagerService;
    @Mock
    private UserManagementResourceHelper jobRequestHelper;
    @Mock
    private AppFormerActivities appFormerActivities;
    @InjectMocks
    UserManagementResource userManagementResource = new UserManagementResource(){

        protected void assertObjectExists(Object o, String objectInfo, String objectName) {
        }

        protected Variant getDefaultVariant() {
            return null;
        }

        protected Response createResponse(UberfireRestResponse restResponse) {
            return null;
        }
    };

    @Test
    public void getAllGroupsTest() throws Exception {
        Mockito.when((Object)this.groupManagerService.getAll()).thenReturn((Object)new Lists.Builder().add((Object)new GroupImpl("testGroup")).build());
        Assertions.assertThat((Iterable)this.userManagementResource.getGroups()).isNotNull();
    }

    @Test
    public void getAllRolesTest() throws Exception {
        Mockito.when((Object)this.roleManagerService.getAll()).thenReturn((Object)new Lists.Builder().add((Object)new RoleImpl("testRole")).build());
        Assertions.assertThat((int)this.userManagementResource.getRoles().size()).isOne();
    }

    @Test
    public void getAllUsersTest() throws Exception {
        Mockito.when((Object)this.userManagerService.getAll()).thenReturn((Object)new Lists.Builder().add((Object)new UserImpl("testuser")).build());
        Assertions.assertThat((int)this.userManagementResource.getUsers().size()).isOne();
    }

    @Test
    public void getAllEditorsTest() throws Exception {
        List perspectives = new Lists.Builder().add((Object)"perpective1").add((Object)"perpective2").build();
        Mockito.when((Object)this.appFormerActivities.getAllPerpectivesIds()).thenReturn((Object)perspectives);
        Assertions.assertThat((int)this.userManagementResource.getPerpectives().size()).isEqualTo(2);
    }

    @Test
    public void getAllPerspectivesTest() throws Exception {
        List editors = new Lists.Builder().add((Object)"editor1").add((Object)"editor2").add((Object)"editor3").build();
        Mockito.when((Object)this.appFormerActivities.getAllEditorIds()).thenReturn((Object)editors);
        Assertions.assertThat((int)this.userManagementResource.getEditors().size()).isEqualTo(3);
    }

    @Test
    public void getUserGroupsTest() throws Exception {
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getGroups()).thenReturn((Object)new Sets.Builder().add((Object)new GroupImpl("testgroup")).build());
        Mockito.when((Object)this.userManagerService.getUser("testUser")).thenReturn((Object)user);
        Assertions.assertThat((int)this.userManagementResource.getUserGroups("testUser").size()).isOne();
    }

    @Test
    public void getUserRolesTest() throws Exception {
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getRoles()).thenReturn((Object)new Sets.Builder().add((Object)new RoleImpl("testRole")).build());
        Mockito.when((Object)this.userManagerService.getUser("testUser")).thenReturn((Object)user);
        Assertions.assertThat((int)this.userManagementResource.getUserRoles("testUser").size()).isOne();
    }

    @Test
    public void createGroupTest() throws Exception {
        NewGroup newGroup = new NewGroup();
        this.userManagementResource.createGroup(newGroup);
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).createGroup(newGroup.getName(), newGroup.getUsers());
    }

    @Test
    public void createUserTest() throws Exception {
        NewUser newUser = new NewUser();
        this.userManagementResource.createUser(newUser);
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).createUser(newUser);
    }

    @Test
    public void removeGroupTest() throws Exception {
        this.userManagementResource.deleteGroup("testGroup");
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).removeGroup("testGroup");
    }

    @Test
    public void removeUserTest() throws Exception {
        this.userManagementResource.deleteUser("testUser");
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).removeUser("testUser");
    }

    @Test
    public void assignGroupToUserTest() throws Exception {
        List roles = new Lists.Builder().add((Object)"testRole").build();
        this.userManagementResource.assignRolesToUser("testUser", roles);
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).assignRolesToUser("testUser", roles);
    }

    @Test
    public void assignRolesToUserTest() throws Exception {
        List groups = new Lists.Builder().add((Object)"testGroup").build();
        this.userManagementResource.assignGroupsToUser("testUser", groups);
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).assignGroupsToUser("testUser", groups);
    }

    @Test
    public void updateGroupSettingTest() throws Exception {
        UpdateSettingRequest settingRequest = new UpdateSettingRequest();
        this.userManagementResource.updateGroupPermissions("groupName", settingRequest);
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).updateGroupPermissions("groupName", settingRequest);
    }

    @Test
    public void updateRoleSettingTest() throws Exception {
        UpdateSettingRequest settingRequest = new UpdateSettingRequest();
        this.userManagementResource.updateRolePermissions("roleName", settingRequest);
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).updateRolePermissions("roleName", settingRequest);
    }

    @Test
    public void getRolePermisssionTest() throws Exception {
        this.userManagementResource.getRolePermissions("roleName");
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).getRolePermissions("roleName");
    }

    @Test
    public void getGroupPermisssionTest() throws Exception {
        this.userManagementResource.getGroupPermissions("groupname");
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).getGroupPermissions("groupname");
    }

    @Test
    public void getUserPermisssionTest() throws Exception {
        this.userManagementResource.getUserPermissions("userName");
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).getUserPermissions("userName");
    }

    @Test
    public void getchangePasswordTest() throws Exception {
        this.userManagementResource.changePassword("user", "newPassword");
        ((UserManagementResourceHelper)Mockito.verify((Object)this.jobRequestHelper)).changePassword("user", "newPassword");
    }
}

