/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.guvnor.rest.backend.PermissionAction;
import org.guvnor.rest.backend.ResourceTypePermissionValidator;
import org.guvnor.rest.client.NewUser;
import org.guvnor.rest.client.PermissionException;
import org.guvnor.rest.client.PermissionResponse;
import org.guvnor.rest.client.PermissionType;
import org.guvnor.rest.client.ResourcePermission;
import org.guvnor.rest.client.UberfireRestResponse;
import org.guvnor.rest.client.UpdateSettingRequest;
import org.guvnor.rest.client.WorkbenchPermission;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.security.RepositoryAction;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.authz.AuthorizationService;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.api.service.GroupManagerService;
import org.uberfire.ext.security.management.api.service.RoleManagerService;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.workbench.model.ActivityResourceType;

@ApplicationScoped
public class UserManagementResourceHelper {
    private static final Logger logger = LoggerFactory.getLogger(UserManagementResourceHelper.class);
    private static final String EDIT_GLOBAL_PREFERENCES = "globalpreferences.edit";
    private static final String GUIDED_DECISION_TABLE_EDIT_COLUMNS = "guideddecisiontable.edit.columns";
    private static final String EDIT_PROFILE_PREFERENCES = "profilepreferences.edit";
    private static final String ACCESS_DATA_TRANSFER = "datatransfer.access";
    private static final String EDIT_SOURCES = "dataobject.edit";
    private static final String JAR_DOWNLOAD = "jar.download";
    private static final String PLANNER_AVAILABLE = "planner.available";
    @Inject
    private GroupManagerService groupManagerService;
    @Inject
    private UserManagerService userManagerService;
    @Inject
    private RoleManagerService roleManagerService;
    @Inject
    private AuthorizationService authorizationService;
    @Inject
    private PermissionManager permissionManager;
    @Inject
    private ResourceTypePermissionValidator permissionValidator;

    public UberfireRestResponse createGroup(String groupName, List<String> users) {
        UberfireRestResponse response = new UberfireRestResponse();
        if (groupName == null) {
            response.setStatus(Response.Status.BAD_REQUEST);
            response.setMessage("Group name cannot be empty");
        }
        try {
            Group group = (Group)this.groupManagerService.get(groupName);
            if (group != null) {
                response.setStatus(Response.Status.BAD_REQUEST);
                response.setMessage("Group with name " + groupName + " already exists");
            }
        }
        catch (GroupNotFoundException e) {
            if (!this.areUsersValid(users)) {
                response.setStatus(Response.Status.BAD_REQUEST);
                response.setMessage("Usernames are invalid, please check");
                return response;
            }
            Group group = (Group)this.groupManagerService.create((Object)new GroupImpl(groupName));
            this.groupManagerService.assignUsers(groupName, users);
            if (group != null) {
                response.setStatus(Response.Status.OK);
                response.setMessage("Group " + group.getName() + " is created successfully.");
            } else {
                response.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String errMsg = e.getClass().getSimpleName() + " thrown when trying to create '" + groupName + "': " + e.getMessage();
            logger.error(errMsg, (Throwable)e);
            response.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            response.setMessage(errMsg);
        }
        return response;
    }

    public UberfireRestResponse createUser(NewUser newUser) {
        UberfireRestResponse response = new UberfireRestResponse();
        if (newUser.getName() == null) {
            response.setStatus(Response.Status.BAD_REQUEST);
            response.setMessage("User name cannot be empty");
            return response;
        }
        try {
            if (!this.areRolesValid(newUser.getRoles()) || !this.areGroupsValid(newUser.getGroups())) {
                response.setStatus(Response.Status.BAD_REQUEST);
                response.setMessage("User roles/groups are invalid. Please check ");
                return response;
            }
            User user = (User)this.userManagerService.get(newUser.getName());
            if (user != null) {
                response.setStatus(Response.Status.BAD_REQUEST);
                response.setMessage("User with name " + newUser.getName() + " already exists");
            }
        }
        catch (UserNotFoundException e) {
            User userCreated = (User)this.userManagerService.create((Object)this.createUserObject(newUser));
            if (userCreated != null) {
                response.setStatus(Response.Status.OK);
                response.setMessage("User " + userCreated.getIdentifier() + " is created successfully.");
            } else {
                response.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String errMsg = e.getClass().getSimpleName() + " thrown when trying to create '" + newUser.getName() + "': " + e.getMessage();
            logger.error(errMsg, (Throwable)e);
            response.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            response.setMessage(errMsg);
        }
        return response;
    }

    public UberfireRestResponse changePassword(String user, String newPassword) {
        UberfireRestResponse response = new UberfireRestResponse();
        try {
            this.userManagerService.changePassword(user, newPassword);
            response.setStatus(Response.Status.OK);
            response.setMessage("Password for " + user + " has been updated successfully.");
        }
        catch (Exception e) {
            String errMsg = e.getClass().getSimpleName() + " thrown when trying to update password for '" + user + "': " + e.getMessage();
            logger.error(errMsg, (Throwable)e);
            response.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            response.setMessage(errMsg);
        }
        return response;
    }

    public UberfireRestResponse removeGroup(String groupName) {
        UberfireRestResponse response = new UberfireRestResponse();
        try {
            this.groupManagerService.delete(new String[]{groupName});
            response.setStatus(Response.Status.OK);
            response.setMessage("Group " + groupName + " is deleted successfully.");
        }
        catch (Exception e) {
            String errMsg = e.getClass().getSimpleName() + " thrown when trying to remove '" + groupName + "': " + e.getMessage();
            logger.error(errMsg, (Throwable)e);
            response.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            response.setMessage(errMsg);
        }
        return response;
    }

    public UberfireRestResponse removeUser(String userName) {
        UberfireRestResponse response = new UberfireRestResponse();
        try {
            this.userManagerService.delete(new String[]{userName});
            response.setStatus(Response.Status.OK);
            response.setMessage("User " + userName + " is deleted successfully.");
        }
        catch (Exception e) {
            String errMsg = e.getClass().getSimpleName() + " thrown when trying to remove '" + userName + "': " + e.getMessage();
            logger.error(errMsg, (Throwable)e);
            response.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            response.setMessage(errMsg);
        }
        return response;
    }

    public UberfireRestResponse assignGroupsToUser(String userName, List<String> groups) {
        UberfireRestResponse response = new UberfireRestResponse();
        try {
            if (!this.areGroupsValid(groups)) {
                response.setStatus(Response.Status.BAD_REQUEST);
                response.setMessage("Groups " + groups + " are not valid ");
                return response;
            }
            this.userManagerService.assignGroups(userName, groups);
            response.setStatus(Response.Status.OK);
            response.setMessage("Groups " + groups + " are assigned successfully to user " + userName);
        }
        catch (Exception e) {
            String errMsg = e.getClass().getSimpleName() + " thrown when trying to assign groups to user  '" + userName + "': " + e.getMessage();
            logger.error(errMsg, (Throwable)e);
            response.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            response.setMessage(errMsg);
        }
        return response;
    }

    public UberfireRestResponse assignRolesToUser(String userName, List<String> roles) {
        UberfireRestResponse response = new UberfireRestResponse();
        try {
            if (!this.areRolesValid(roles)) {
                response.setStatus(Response.Status.BAD_REQUEST);
                response.setMessage("Roles " + roles + " are not valid ");
            }
            this.userManagerService.assignRoles(userName, roles);
            response.setStatus(Response.Status.OK);
            response.setMessage("Roles " + roles + " are assigned successfully to user " + userName);
        }
        catch (Exception e) {
            String errMsg = e.getClass().getSimpleName() + " thrown when trying to assign roles to user  '" + userName + "': " + e.getMessage();
            logger.error(errMsg, (Throwable)e);
            response.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            response.setMessage(errMsg);
        }
        return response;
    }

    public PermissionResponse getGroupPermissions(String groupName) {
        PermissionResponse permissionResponse = new PermissionResponse();
        Group group = (Group)this.groupManagerService.get(groupName);
        if (group != null) {
            AuthorizationPolicy authzPolicy = this.permissionManager.getAuthorizationPolicy();
            PermissionCollection pc = authzPolicy.getPermissions(group);
            permissionResponse.setPriority(Integer.valueOf(authzPolicy.getPriority(group)));
            permissionResponse.setHomePage(authzPolicy.getHomePerspective(group));
            this.convertCollectionToPermissionResponse(permissionResponse, pc);
            permissionResponse.setWorkbench(this.getWorkbenchPermissions(pc));
        }
        return permissionResponse;
    }

    public PermissionResponse getRolePermissions(String roleName) {
        PermissionResponse permissionResponse = new PermissionResponse();
        Role role = (Role)this.roleManagerService.get(roleName);
        if (role != null) {
            AuthorizationPolicy authzPolicy = this.permissionManager.getAuthorizationPolicy();
            PermissionCollection pc = authzPolicy.getPermissions(role);
            permissionResponse.setPriority(Integer.valueOf(authzPolicy.getPriority(role)));
            permissionResponse.setHomePage(authzPolicy.getHomePerspective(role));
            this.convertCollectionToPermissionResponse(permissionResponse, pc);
            permissionResponse.setWorkbench(this.getWorkbenchPermissions(pc));
        }
        return permissionResponse;
    }

    public PermissionResponse getUserPermissions(String userName) {
        PermissionResponse permissionResponse = new PermissionResponse();
        User user = (User)this.userManagerService.get(userName);
        PermissionCollection pc = this.permissionManager.resolvePermissions(user, VotingStrategy.PRIORITY);
        this.convertCollectionToPermissionResponse(permissionResponse, pc);
        permissionResponse.setWorkbench(this.getWorkbenchPermissions(pc));
        return permissionResponse;
    }

    public UberfireRestResponse updateGroupPermissions(String groupName, UpdateSettingRequest permissionsRequest) {
        UberfireRestResponse response = new UberfireRestResponse();
        try {
            Group group = (Group)this.groupManagerService.get(groupName);
            AuthorizationPolicy authzPolicy = this.permissionManager.getAuthorizationPolicy();
            if (permissionsRequest.getHomePage() != null && this.permissionValidator.isValidResourceType((ResourceType)ActivityResourceType.PERSPECTIVE, permissionsRequest.getHomePage())) {
                authzPolicy.setHomePerspective(group, permissionsRequest.getHomePage());
            }
            if (permissionsRequest.getPriority() != null) {
                authzPolicy.setPriority(group, permissionsRequest.getPriority().intValue());
            }
            PermissionCollection pc = authzPolicy.getPermissions(group);
            this.generatePermissionCollection(pc, permissionsRequest);
            authzPolicy.setPermissions(group, pc);
            this.authorizationService.savePolicy(authzPolicy);
            response.setStatus(Response.Status.OK);
            response.setMessage("Group " + groupName + " permissions are updated successfully.");
        }
        catch (GroupNotFoundException e) {
            response.setStatus(Response.Status.BAD_REQUEST);
            response.setMessage("Group with name " + groupName + "doesn't exists");
        }
        catch (Exception e) {
            String errMsg = e.getClass().getSimpleName() + " thrown when trying to update permissions for  '" + groupName + "': " + e.getMessage();
            logger.error(errMsg, (Throwable)e);
            response.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            response.setMessage(errMsg);
        }
        return response;
    }

    public UberfireRestResponse updateRolePermissions(String roleName, UpdateSettingRequest permissionsRequest) {
        UberfireRestResponse response = new UberfireRestResponse();
        try {
            Role role = (Role)this.roleManagerService.get(roleName);
            if (role != null) {
                AuthorizationPolicy authzPolicy = this.permissionManager.getAuthorizationPolicy();
                if (permissionsRequest.getHomePage() != null && this.permissionValidator.isValidResourceType((ResourceType)ActivityResourceType.PERSPECTIVE, permissionsRequest.getHomePage())) {
                    authzPolicy.setHomePerspective(role, permissionsRequest.getHomePage());
                }
                if (permissionsRequest.getPriority() != null) {
                    authzPolicy.setPriority(role, permissionsRequest.getPriority().intValue());
                }
                PermissionCollection pc = authzPolicy.getPermissions(role);
                this.generatePermissionCollection(pc, permissionsRequest);
                authzPolicy.setPermissions(role, pc);
                this.authorizationService.savePolicy(authzPolicy);
                response.setStatus(Response.Status.OK);
                response.setMessage("Role " + roleName + " permissions are updated successfully.");
            } else {
                response.setStatus(Response.Status.BAD_REQUEST);
                response.setMessage("Role with name " + roleName + "doesn't exists");
            }
        }
        catch (Exception e) {
            String errMsg = e.getClass().getSimpleName() + " thrown when trying to update permissions for  '" + roleName + "': " + e.getMessage();
            logger.error(errMsg, (Throwable)e);
            response.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            response.setMessage(errMsg);
        }
        return response;
    }

    private void convertCollectionToPermissionResponse(PermissionResponse permissionResponse, PermissionCollection pc) {
        for (Map.Entry<ResourceType, List<PermissionAction>> entry : this.permissionValidator.getPermissionEntries()) {
            ResourcePermission permission = new ResourcePermission();
            ResourceType resourceType = entry.getKey();
            List<PermissionAction> resourceActions = entry.getValue();
            for (PermissionAction resourceAction : resourceActions) {
                PermissionType permissionType = this.getPermissionsType(pc, resourceType, resourceAction.getResourceAction());
                this.getPermissions(permission, resourceAction.getResourceAction(), permissionType);
            }
            if (resourceType.equals(ActivityResourceType.PERSPECTIVE)) {
                permissionResponse.setPages(permission);
            }
            if (resourceType.equals(OrganizationalUnit.RESOURCE_TYPE)) {
                permissionResponse.setSpaces(permission);
            }
            if (resourceType.equals(ActivityResourceType.EDITOR)) {
                permissionResponse.setEditor(permission);
            }
            if (!resourceType.equals(Repository.RESOURCE_TYPE)) continue;
            permissionResponse.setProject(permission);
        }
    }

    private WorkbenchPermission getWorkbenchPermissions(PermissionCollection pc) {
        WorkbenchPermission workbenchPermission = new WorkbenchPermission();
        workbenchPermission.setAccessDataTransfer(Boolean.valueOf(this.resolvePermission(pc, ACCESS_DATA_TRANSFER)));
        workbenchPermission.setEditDataObject(Boolean.valueOf(this.resolvePermission(pc, EDIT_SOURCES)));
        workbenchPermission.setEditGlobalPreferences(Boolean.valueOf(this.resolvePermission(pc, EDIT_GLOBAL_PREFERENCES)));
        workbenchPermission.setEditProfilePreferences(Boolean.valueOf(this.resolvePermission(pc, EDIT_PROFILE_PREFERENCES)));
        workbenchPermission.setJarDownload(Boolean.valueOf(this.resolvePermission(pc, JAR_DOWNLOAD)));
        workbenchPermission.setPlannerAvailable(Boolean.valueOf(this.resolvePermission(pc, PLANNER_AVAILABLE)));
        workbenchPermission.setEditGuidedDecisionTableColumns(Boolean.valueOf(this.resolvePermission(pc, GUIDED_DECISION_TABLE_EDIT_COLUMNS)));
        return workbenchPermission;
    }

    private boolean resolvePermission(PermissionCollection pc, String permission) {
        Permission resolvedPermission = pc.get(permission);
        if (resolvedPermission != null) {
            AuthorizationResult result = resolvedPermission.getResult();
            return result.equals((Object)AuthorizationResult.ACCESS_GRANTED);
        }
        return false;
    }

    private void getPermissions(ResourcePermission permission, ResourceAction resourceAction, PermissionType permissionType) {
        if (resourceAction.equals(ResourceAction.READ)) {
            permission.setRead(permissionType);
        }
        if (resourceAction.equals(RepositoryAction.CREATE)) {
            permission.setCreate(permissionType);
        }
        if (resourceAction.equals(RepositoryAction.BUILD)) {
            permission.setBuild(permissionType);
        }
        if (resourceAction.equals(RepositoryAction.UPDATE)) {
            permission.setUpdate(permissionType);
        }
        if (resourceAction.equals(RepositoryAction.DELETE)) {
            permission.setDelete(permissionType);
        }
    }

    private PermissionType getPermissionsType(PermissionCollection pc, ResourceType resourceType, ResourceAction resourceAction) {
        PermissionType permissionType = new PermissionType();
        ArrayList<String> exceptions = new ArrayList<String>();
        String permissionName = resourceType.getName() + "." + resourceAction.getName();
        Permission parentPermission = pc.get(permissionName);
        if (parentPermission != null) {
            AuthorizationResult result = parentPermission.getResult();
            permissionType.setAccess(result.equals((Object)AuthorizationResult.ACCESS_GRANTED));
            for (Permission permission : pc.collection()) {
                if (!parentPermission.impliesName(permission) || parentPermission.impliesResult(permission)) continue;
                String resourceId = this.permissionManager.resolveResourceId(permission);
                exceptions.add(resourceId);
            }
            permissionType.setExceptions(exceptions);
        }
        return permissionType;
    }

    private PermissionCollection generatePermissionCollection(PermissionCollection pc, UpdateSettingRequest permissionRequest) {
        if (permissionRequest.getPages() != null) {
            this.addToCollection(pc, (ResourceType)ActivityResourceType.PERSPECTIVE, permissionRequest.getPages());
        }
        if (permissionRequest.getSpaces() != null) {
            this.addToCollection(pc, (ResourceType)OrganizationalUnit.RESOURCE_TYPE, permissionRequest.getSpaces());
        }
        if (permissionRequest.getProject() != null) {
            this.addToCollection(pc, (ResourceType)Repository.RESOURCE_TYPE, permissionRequest.getProject());
        }
        if (permissionRequest.getEditor() != null) {
            this.addToCollection(pc, (ResourceType)ActivityResourceType.EDITOR, permissionRequest.getEditor());
        }
        if (permissionRequest.getWorkbench() != null) {
            this.addWorkBenchPermissions(pc, permissionRequest.getWorkbench());
        }
        return pc;
    }

    private void addWorkBenchPermissions(PermissionCollection pc, WorkbenchPermission permission) {
        if (permission.getAccessDataTransfer() != null) {
            pc.add(new Permission[]{this.permissionManager.createPermission(ACCESS_DATA_TRANSFER, permission.getAccessDataTransfer().booleanValue())});
        }
        if (permission.getEditDataObject() != null) {
            pc.add(new Permission[]{this.permissionManager.createPermission(EDIT_SOURCES, permission.getEditDataObject().booleanValue())});
        }
        if (permission.getEditGlobalPreferences() != null) {
            pc.add(new Permission[]{this.permissionManager.createPermission(EDIT_GLOBAL_PREFERENCES, permission.getEditGlobalPreferences().booleanValue())});
        }
        if (permission.getEditProfilePreferences() != null) {
            pc.add(new Permission[]{this.permissionManager.createPermission(EDIT_PROFILE_PREFERENCES, permission.getEditProfilePreferences().booleanValue())});
        }
        if (permission.getJarDownload() != null) {
            pc.add(new Permission[]{this.permissionManager.createPermission(JAR_DOWNLOAD, permission.getJarDownload().booleanValue())});
        }
        if (permission.getPlannerAvailable() != null) {
            pc.add(new Permission[]{this.permissionManager.createPermission(PLANNER_AVAILABLE, permission.getPlannerAvailable().booleanValue())});
        }
        if (permission.getEditGuidedDecisionTableColumns() != null) {
            pc.add(new Permission[]{this.permissionManager.createPermission(GUIDED_DECISION_TABLE_EDIT_COLUMNS, permission.getEditGuidedDecisionTableColumns().booleanValue())});
        }
    }

    private void addToCollection(PermissionCollection pc, ResourceType resourceType, org.guvnor.rest.client.Permission permission) {
        if (permission.isRead() != null && this.permissionValidator.isPermissionAllowed(resourceType, ResourceAction.READ) && this.permissionValidator.satisfyDependancies(pc, resourceType, ResourceAction.READ)) {
            pc.add(new Permission[]{this.permissionManager.createPermission(resourceType, ResourceAction.READ, permission.isRead().booleanValue())});
        }
        if (permission.isCreate() != null && this.permissionValidator.isPermissionAllowed(resourceType, (ResourceAction)RepositoryAction.CREATE) && this.permissionValidator.satisfyDependancies(pc, resourceType, (ResourceAction)RepositoryAction.CREATE)) {
            pc.add(new Permission[]{this.permissionManager.createPermission(resourceType, (ResourceAction)RepositoryAction.CREATE, permission.isCreate().booleanValue())});
        }
        if (permission.isUpdate() != null && this.permissionValidator.isPermissionAllowed(resourceType, (ResourceAction)RepositoryAction.UPDATE) && this.permissionValidator.satisfyDependancies(pc, resourceType, (ResourceAction)RepositoryAction.UPDATE)) {
            pc.add(new Permission[]{this.permissionManager.createPermission(resourceType, (ResourceAction)RepositoryAction.UPDATE, permission.isUpdate().booleanValue())});
        }
        if (permission.isDelete() != null && this.permissionValidator.isPermissionAllowed(resourceType, (ResourceAction)RepositoryAction.DELETE) && this.permissionValidator.satisfyDependancies(pc, resourceType, (ResourceAction)RepositoryAction.DELETE)) {
            pc.add(new Permission[]{this.permissionManager.createPermission(resourceType, (ResourceAction)RepositoryAction.DELETE, permission.isDelete().booleanValue())});
        }
        if (permission.isBuild() != null && this.permissionValidator.isPermissionAllowed(resourceType, (ResourceAction)RepositoryAction.BUILD) && this.permissionValidator.satisfyDependancies(pc, resourceType, (ResourceAction)RepositoryAction.BUILD)) {
            pc.add(new Permission[]{this.permissionManager.createPermission(resourceType, (ResourceAction)RepositoryAction.BUILD, permission.isBuild().booleanValue())});
        }
        if (permission.getExceptions() != null) {
            this.addExceptions(pc, resourceType, permission.getExceptions());
        }
    }

    private void addExceptions(PermissionCollection pc, ResourceType resourceType, List<PermissionException> exceptions) {
        for (PermissionException exception : exceptions) {
            String permissionName;
            org.guvnor.rest.client.Permission permission = exception.getPermissions();
            String resourceTypeName = resourceType.getName();
            if (!this.permissionValidator.isValidResourceType(resourceType, exception.getResourceName())) continue;
            if (permission.isRead() != null && this.permissionValidator.isPermissionAllowed(resourceType, ResourceAction.READ)) {
                permissionName = resourceTypeName + "." + ResourceAction.READ.getName() + "." + exception.getResourceName();
                pc.add(new Permission[]{this.permissionManager.createPermission(permissionName, permission.isRead().booleanValue())});
                continue;
            }
            if (permission.isCreate() != null && this.permissionValidator.isPermissionAllowed(resourceType, (ResourceAction)RepositoryAction.CREATE)) {
                permissionName = resourceTypeName + "." + RepositoryAction.CREATE.getName() + "." + exception.getResourceName();
                pc.add(new Permission[]{this.permissionManager.createPermission(permissionName, permission.isCreate().booleanValue())});
                continue;
            }
            if (permission.isUpdate() != null && this.permissionValidator.isPermissionAllowed(resourceType, (ResourceAction)RepositoryAction.UPDATE)) {
                permissionName = resourceTypeName + "." + RepositoryAction.UPDATE.getName() + "." + exception.getResourceName();
                pc.add(new Permission[]{this.permissionManager.createPermission(permissionName, permission.isUpdate().booleanValue())});
                continue;
            }
            if (permission.isDelete() == null || !this.permissionValidator.isPermissionAllowed(resourceType, (ResourceAction)RepositoryAction.DELETE)) continue;
            permissionName = resourceTypeName + "." + RepositoryAction.DELETE.getName() + "." + exception.getResourceName();
            pc.add(new Permission[]{this.permissionManager.createPermission(permissionName, permission.isDelete().booleanValue())});
        }
    }

    private User createUserObject(NewUser newUser) {
        HashSet<RoleImpl> userRoles = new HashSet<RoleImpl>();
        HashSet<GroupImpl> userGroups = new HashSet<GroupImpl>();
        if (newUser.getRoles() != null) {
            for (String roleName : newUser.getRoles()) {
                RoleImpl role = new RoleImpl(roleName);
                userRoles.add(role);
            }
        }
        if (newUser.getGroups() != null) {
            for (String groupName : newUser.getGroups()) {
                GroupImpl group = new GroupImpl(groupName);
                userGroups.add(group);
            }
        }
        return new UserImpl(newUser.getName(), userRoles, userGroups);
    }

    private boolean areUsersValid(List<String> users) {
        if (users != null) {
            try {
                for (String username : users) {
                    User user = (User)this.userManagerService.get(username);
                    if (user != null) continue;
                    return false;
                }
            }
            catch (UserNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    private boolean areGroupsValid(List<String> groups) {
        if (groups != null) {
            for (String groupName : groups) {
                try {
                    Group group = (Group)this.groupManagerService.get(groupName);
                    if (group != null) continue;
                    return false;
                }
                catch (GroupNotFoundException e) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean areRolesValid(List<String> roles) {
        if (roles != null) {
            for (String roleName : roles) {
                Role role = (Role)this.roleManagerService.get(roleName);
                if (role != null) continue;
                return false;
            }
        }
        return true;
    }
}

