/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups;

import com.github.gwtbootstrap.client.ui.AccordionGroup;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.github.gwtbootstrap.client.ui.event.HiddenEvent;
import com.github.gwtbootstrap.client.ui.event.HiddenHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.ext.layout.editor.client.components.ModalConfigurationContext;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.plugin.client.validation.NameValidator;
import org.uberfire.ext.properties.editor.client.PropertyEditorWidget;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class EditScreen
extends BaseModal {
    public static String PROPERTY_EDITOR_KEY = "LayoutEditor";
    private final ModalConfigurationContext configContext;
    @UiField
    TextBox key;
    @UiField
    AccordionGroup paramAccordion;
    @UiField
    ControlGroup paramKeyControlGroup;
    @UiField
    HelpInline paramKeyInline;
    @UiField
    TextBox value;
    @UiField
    PropertyEditorWidget propertyEditor;
    private Boolean revertChanges = Boolean.TRUE;
    private Map<String, String> lastParametersSaved = new HashMap<String, String>();
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public EditScreen(ModalConfigurationContext configContext) {
        this.clearModal();
        this.configContext = configContext;
        this.setTitle(CommonConstants.INSTANCE.EditComponent());
        this.setMaxHeigth("350px");
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.propertyEditor.handle(this.generateEvent(this.generateScreenSettingsCategory()));
        this.saveOriginalState();
        this.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                EditScreen.this.okButton();
            }
        }, new Command(){

            public void execute() {
                EditScreen.this.cancelButton();
            }
        }));
        this.paramAccordion.addHiddenHandler(new HiddenHandler(){

            public void onHidden(HiddenEvent hiddenEvent) {
                hiddenEvent.stopPropagation();
            }
        });
        this.addHiddlenHandler();
    }

    private void clearModal() {
    }

    private void saveOriginalState() {
        this.lastParametersSaved = new HashMap<String, String>();
        Map layoutComponentProperties = this.configContext.getComponentProperties();
        for (String key : layoutComponentProperties.keySet()) {
            this.lastParametersSaved.put(key, (String)layoutComponentProperties.get(key));
        }
    }

    private void addHiddlenHandler() {
        this.addHiddenHandler(new HiddenHandler(){

            public void onHidden(HiddenEvent hiddenEvent) {
                if (EditScreen.this.userPressCloseOrCancel()) {
                    EditScreen.this.revertChanges();
                }
            }
        });
    }

    private void revertChanges() {
        this.configContext.resetComponentProperties();
        for (String key : this.lastParametersSaved.keySet()) {
            this.configContext.setComponentProperty(key, this.lastParametersSaved.get(key));
        }
    }

    private boolean userPressCloseOrCancel() {
        return this.revertChanges;
    }

    public void show() {
        super.show();
    }

    void okButton() {
        super.hide();
        this.revertChanges = Boolean.FALSE;
        if (this.configContext.getComponentProperty("Place Name") == null) {
            List<String> screenIds = this.getWorkbenchScreenIds();
            if (!screenIds.isEmpty()) {
                this.configContext.setComponentProperty("Place Name", screenIds.get(0));
                this.configContext.configurationFinished();
            } else {
                this.configContext.configurationCancelled();
            }
        } else {
            this.configContext.configurationFinished();
        }
    }

    void cancelButton() {
        super.hide();
        this.configContext.configurationCancelled();
    }

    public void hide() {
        super.hide();
    }

    @UiHandler(value={"add"})
    void add(ClickEvent event) {
        PropertyEditorCategory property = this.addProperty();
        if (property == null) {
            return;
        }
        this.propertyEditor.handle(this.generateEvent(property));
        this.key.setText("");
        this.value.setText("");
    }

    private PropertyEditorCategory addProperty() {
        this.paramKeyInline.setText("");
        this.paramKeyControlGroup.setType(ControlGroupType.NONE);
        NameValidator validator = NameValidator.parameterNameValidator();
        if (!validator.isValid(this.key.getText())) {
            this.paramKeyControlGroup.setType(ControlGroupType.ERROR);
            this.paramKeyInline.setText(validator.getValidationError());
            return null;
        }
        Map properties = this.configContext.getComponentProperties();
        for (String parameterKey : properties.keySet()) {
            if (!this.key.getText().equals(parameterKey)) continue;
            this.paramKeyControlGroup.setType(ControlGroupType.ERROR);
            this.paramKeyInline.setText(CommonConstants.INSTANCE.DuplicateParameterName());
            return null;
        }
        this.configContext.setComponentProperty(this.key.getText(), this.value.getText());
        return this.generateScreenSettingsCategory();
    }

    private PropertyEditorCategory generateScreenSettingsCategory() {
        PropertyEditorCategory category = new PropertyEditorCategory("Screen Configuration"){

            public List<PropertyEditorFieldInfo> getFields() {
                return new ArrayList<PropertyEditorFieldInfo>((Collection)super.getFields()){

                    @Override
                    public boolean remove(Object o) {
                        if (o instanceof PropertyEditorFieldInfo) {
                            PropertyEditorFieldInfo info = (PropertyEditorFieldInfo)o;
                            EditScreen.this.configContext.removeComponentProperty(info.getLabel());
                        }
                        return super.remove(o);
                    }
                };
            }
        };
        Map parameters = this.configContext.getComponentProperties();
        String selectedScreenId = (String)parameters.get("Place Name");
        List<String> availableScreenIds = this.getWorkbenchScreenIds();
        category.withField(new PropertyEditorFieldInfo("Place Name", selectedScreenId == null ? "" : selectedScreenId, PropertyEditorType.COMBO).withComboValues(availableScreenIds).withKey(this.configContext.hashCode() + "Place Name"));
        for (String key : parameters.keySet()) {
            if ("Place Name".equals(key)) continue;
            category.withField(new PropertyEditorFieldInfo(key, (String)parameters.get(key), PropertyEditorType.TEXT).withKey(this.configContext.hashCode() + key).withRemovalSupported(true));
        }
        this.propertyEditor.setLastOpenAccordionGroupTitle(category.getName());
        return category;
    }

    private List<String> getWorkbenchScreenIds() {
        ArrayList<String> result = new ArrayList<String>();
        Collection screens = IOC.getBeanManager().lookupBeans(WorkbenchScreenActivity.class);
        for (IOCBeanDef beanDef : screens) {
            result.add(this.getName(beanDef));
        }
        return result;
    }

    private String getName(IOCBeanDef<?> beanDef) {
        for (Annotation annotation : beanDef.getQualifiers()) {
            if (!(annotation instanceof Named)) continue;
            return ((Named)annotation).value();
        }
        return "";
    }

    private PropertyEditorEvent generateEvent(PropertyEditorCategory category) {
        PropertyEditorEvent event = new PropertyEditorEvent(PROPERTY_EDITOR_KEY, category);
        return event;
    }

    static interface Binder
    extends UiBinder<Widget, EditScreen> {
    }
}

