/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.validation;

import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;

public class NameValidator {
    public static final String VALID_DIR_REGEX = "^([^*\"\\/><?\\\\\\!|;:]*)$";
    private String error;

    private NameValidator(String error) {
        this.error = error;
    }

    public static NameValidator tagNameValidator() {
        return new NameValidator(CommonConstants.INSTANCE.InvalidTagName());
    }

    public static NameValidator activityIdValidator() {
        return new NameValidator(CommonConstants.INSTANCE.InvalidActivityID());
    }

    public static NameValidator menuLabelValidator() {
        return new NameValidator(CommonConstants.INSTANCE.InvalidMenuLabel());
    }

    public static NameValidator parameterNameValidator() {
        return new NameValidator(CommonConstants.INSTANCE.InvalidParameterName());
    }

    public String getValidationError() {
        return this.error;
    }

    public boolean isValid(String dirName) {
        if (dirName == null || dirName.isEmpty()) {
            return Boolean.FALSE;
        }
        if (!dirName.matches(VALID_DIR_REGEX)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

