/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.media;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Caption;
import com.github.gwtbootstrap.client.ui.Image;
import com.github.gwtbootstrap.client.ui.Paragraph;
import com.github.gwtbootstrap.client.ui.Thumbnail;
import com.github.gwtbootstrap.client.ui.Thumbnails;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.constants.ImageType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.plugin.client.config.PluginConfigService;
import org.uberfire.ext.plugin.event.MediaAdded;
import org.uberfire.ext.plugin.event.MediaDeleted;
import org.uberfire.ext.plugin.model.Media;
import org.uberfire.ext.widgets.common.client.common.FileUpload;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class MediaLibraryWidget
extends Composite
implements RequiresResize {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    @UiField
    FlowPanel content;
    @UiField
    FormPanel form;
    @UiField(provided=true)
    FileUpload fileUpload;
    @UiField
    FlowPanel library;
    @UiField
    Thumbnails thumbs;
    @Inject
    private PluginConfigService pluginConfigService;
    private String pluginName;
    private ParameterizedCommand<Media> onMediaDelete;
    private Map<Path, Thumbnail> mediaRef = new HashMap<Path, Thumbnail>();

    @PostConstruct
    public void init() {
        this.fileUpload = this.createFileUpload();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        this.form.addSubmitHandler(new FormPanel.SubmitHandler(){

            public void onSubmit(FormPanel.SubmitEvent event) {
                String fileName = MediaLibraryWidget.this.fileUpload.getFilename();
                if (this.isNullOrEmpty(fileName)) {
                    event.cancel();
                }
            }

            private boolean isNullOrEmpty(String fileName) {
                return fileName == null || "".equals(fileName);
            }
        });
        this.form.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                if ("OK".equalsIgnoreCase(event.getResults())) {
                    Window.alert((String)"Upload Success");
                } else if ("FAIL".equalsIgnoreCase(event.getResults())) {
                    Window.alert((String)"Upload Failed");
                } else if ("FAIL - ALREADY EXISTS".equalsIgnoreCase(event.getResults())) {
                    Window.alert((String)"File already exists");
                }
            }
        });
    }

    public void setup(String pluginName, Collection<Media> mediaLibrary, ParameterizedCommand<Media> onMediaDelete) {
        this.pluginName = pluginName;
        this.onMediaDelete = onMediaDelete;
        this.mediaRef.clear();
        this.thumbs.clear();
        for (Media media : mediaLibrary) {
            this.addMedia(media);
        }
    }

    private FileUpload createFileUpload() {
        return new FileUpload(new Command(){

            public void execute() {
                MediaLibraryWidget.this.form.setAction(GWT.getHostPageBaseURL().replaceAll("/" + GWT.getModuleName(), "") + MediaLibraryWidget.this.pluginConfigService.getMediaServletURI() + MediaLibraryWidget.this.pluginName);
                MediaLibraryWidget.this.form.submit();
            }
        }, true);
    }

    public void onResize() {
        this.getParent().getElement().getStyle().setBackgroundColor("#F6F6F6");
        this.content.getElement().getStyle().setTop(60.0, Style.Unit.PX);
    }

    public void onNewMedia(@Observes MediaAdded mediaAddedEvent) {
        if (mediaAddedEvent.getPluginName().equals(this.pluginName)) {
            this.addMedia(mediaAddedEvent.getMedia());
        }
    }

    public void onMediaDelete(@Observes MediaDeleted mediaDeleted) {
        Thumbnail thumb;
        if (mediaDeleted.getPluginName().equals(this.pluginName) && (thumb = this.mediaRef.get(mediaDeleted.getMedia().getPath())) != null) {
            this.thumbs.remove((Widget)thumb);
        }
    }

    public void addMedia(final Media media) {
        final Button trash = new Button();
        trash.setIcon(IconType.TRASH);
        final Thumbnail thumbnail = new Thumbnail(){
            {
                this.add((Widget)new Image(media.getPreviewURI()){
                    {
                        this.setType(ImageType.CIRCLE);
                        this.setHeight("140px");
                        this.setWidth("140px");
                    }
                });
                this.add((Widget)new Caption(){
                    {
                        this.add((Widget)new Paragraph(media.getExternalURI()){
                            {
                                this.getElement().getStyle().setProperty("maxWidth", "180px");
                            }
                        });
                        this.add((Widget)new Paragraph(){
                            {
                                this.add((Widget)trash);
                            }
                        });
                    }
                });
            }
        };
        trash.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MediaLibraryWidget.this.mediaRef.remove(media.getPath());
                MediaLibraryWidget.this.onMediaDelete.execute((Object)media);
                MediaLibraryWidget.this.thumbs.remove((Widget)thumbnail);
            }
        });
        this.mediaRef.put(media.getPath(), thumbnail);
        this.thumbs.add((Widget)thumbnail);
    }

    static interface ViewBinder
    extends UiBinder<Widget, MediaLibraryWidget> {
    }
}

