/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.info;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.uberfire.client.editor.JSEditorActivity;
import org.uberfire.client.mvp.ActivityBeansInfo;
import org.uberfire.client.perspective.JSWorkbenchPerspectiveActivity;
import org.uberfire.client.screen.JSWorkbenchScreenActivity;
import org.uberfire.client.splash.JSSplashScreenActivity;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.type.ClientTypeRegistry;
import org.uberfire.ext.plugin.client.type.DynamicMenuResourceType;
import org.uberfire.ext.plugin.client.type.EditorPluginResourceType;
import org.uberfire.ext.plugin.client.type.PerspectiveLayoutPluginResourceType;
import org.uberfire.ext.plugin.client.type.ScreenPluginResourceType;
import org.uberfire.ext.plugin.client.type.SplashPluginResourceType;
import org.uberfire.ext.plugin.model.Activity;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;

@ApplicationScoped
public class PluginsInfo {
    private EditorPluginResourceType editorPluginResourceType;
    private PerspectiveLayoutPluginResourceType perspectiveLayoutPluginResourceType;
    private ScreenPluginResourceType screenPluginResourceType;
    private SplashPluginResourceType splashPluginResourceType;
    private DynamicMenuResourceType dynamicMenuResourceType;
    private ActivityBeansInfo activityBeansInfo;
    private ClientTypeRegistry clientTypeRegistry;

    public PluginsInfo() {
    }

    @Inject
    public PluginsInfo(EditorPluginResourceType editorPluginResourceType, PerspectiveLayoutPluginResourceType perspectiveLayoutPluginResourceType, ScreenPluginResourceType screenPluginResourceType, SplashPluginResourceType splashPluginResourceType, DynamicMenuResourceType dynamicMenuResourceType, ActivityBeansInfo activityBeansInfo, ClientTypeRegistry clientTypeRegistry) {
        this.editorPluginResourceType = editorPluginResourceType;
        this.perspectiveLayoutPluginResourceType = perspectiveLayoutPluginResourceType;
        this.screenPluginResourceType = screenPluginResourceType;
        this.splashPluginResourceType = splashPluginResourceType;
        this.dynamicMenuResourceType = dynamicMenuResourceType;
        this.activityBeansInfo = activityBeansInfo;
        this.clientTypeRegistry = clientTypeRegistry;
    }

    public Set<Activity> getAllPlugins(Collection<Plugin> plugins) {
        HashSet<Activity> activities = new HashSet<Activity>();
        Collection<Set<Activity>> groupedActivities = this.getClassifiedPlugins(plugins).values();
        for (Set<Activity> groupOfActivities : groupedActivities) {
            activities.addAll(groupOfActivities);
        }
        return activities;
    }

    public Map<ClientResourceType, Set<Activity>> getClassifiedPlugins(Collection<Plugin> plugins) {
        LinkedHashMap<ClientResourceType, Set<Activity>> classified = new LinkedHashMap<ClientResourceType, Set<Activity>>();
        classified.put(this.perspectiveLayoutPluginResourceType, new HashSet());
        classified.put(this.screenPluginResourceType, new HashSet());
        classified.put(this.editorPluginResourceType, new HashSet());
        classified.put(this.splashPluginResourceType, new HashSet());
        classified.put(this.dynamicMenuResourceType, new HashSet());
        for (String screenId : this.activityBeansInfo.getAvailableWorkbenchScreensIds()) {
            ((Set)classified.get((Object)this.screenPluginResourceType)).add(new Activity(screenId, PluginType.SCREEN));
        }
        for (String perspectiveId : this.activityBeansInfo.getAvailablePerspectivesIds()) {
            ((Set)classified.get((Object)this.perspectiveLayoutPluginResourceType)).add(new Activity(perspectiveId, PluginType.PERSPECTIVE));
        }
        for (String editorId : this.activityBeansInfo.getAvailableWorkbenchEditorsIds()) {
            ((Set)classified.get((Object)this.editorPluginResourceType)).add(new Activity(editorId, PluginType.EDITOR));
        }
        for (String splashId : this.activityBeansInfo.getAvailableSplashScreensIds()) {
            ((Set)classified.get((Object)this.splashPluginResourceType)).add(new Activity(splashId, PluginType.SPLASH));
        }
        for (Plugin plugin : plugins) {
            ClientResourceType type = this.clientTypeRegistry.resolve(plugin.getPath());
            if (type == null) continue;
            ((Set)classified.get(type)).add(plugin);
        }
        Collection jsscreens = IOC.getBeanManager().lookupBeans(JSWorkbenchScreenActivity.class);
        for (IOCBeanDef beanDef : jsscreens) {
            ((Set)classified.get((Object)this.screenPluginResourceType)).add(new Activity(beanDef.getName(), PluginType.SCREEN));
        }
        Collection jsperspectives = IOC.getBeanManager().lookupBeans(JSWorkbenchPerspectiveActivity.class);
        for (IOCBeanDef beanDef : jsperspectives) {
            ((Set)classified.get((Object)this.perspectiveLayoutPluginResourceType)).add(new Activity(beanDef.getName(), PluginType.PERSPECTIVE));
        }
        Collection jseditors = IOC.getBeanManager().lookupBeans(JSEditorActivity.class);
        for (IOCBeanDef beanDef : jseditors) {
            ((Set)classified.get((Object)this.editorPluginResourceType)).add(new Activity(beanDef.getName(), PluginType.EDITOR));
        }
        Collection jssplashes = IOC.getBeanManager().lookupBeans(JSSplashScreenActivity.class);
        for (IOCBeanDef beanDef : jssplashes) {
            ((Set)classified.get((Object)this.splashPluginResourceType)).add(new Activity(beanDef.getName(), PluginType.SPLASH));
        }
        return classified;
    }
}

