/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.TextArea;
import org.uberfire.ext.layout.editor.client.components.ModalConfigurationContext;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.ButtonPressed;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class EditHTML
extends BaseModal {
    private ModalConfigurationContext configContext;
    private static final String DEFAULT_HTML = CommonConstants.INSTANCE.HTMLplaceHolder();
    @UiField
    TextArea textArea;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private ButtonPressed buttonPressed = ButtonPressed.CLOSE;

    public EditHTML(ModalConfigurationContext ctx) {
        this.configContext = ctx;
        this.setTitle(CommonConstants.INSTANCE.EditHtml());
        this.add((Widget)new ModalBody(){
            {
                this.add((Widget)uiBinder.createAndBindUi((Object)EditHTML.this));
            }
        });
        this.setupHTMLEditor();
        this.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                EditHTML.this.okButton();
            }
        }, new Command(){

            public void execute() {
                EditHTML.this.cancelButton();
            }
        }));
        this.addHiddenHandler();
    }

    protected KeyDownHandler getEnterDomHandler() {
        return new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (!this.isInsideEditHTMLWidget(event) && event.getNativeKeyCode() == 13 && EditHTML.this.handleDefaultAction()) {
                    event.preventDefault();
                    event.stopPropagation();
                }
            }

            private boolean isInsideEditHTMLWidget(KeyDownEvent event) {
                return event.getSource() == EditHTML.this;
            }
        };
    }

    private void setupHTMLEditor() {
        String html = this.configContext.getComponentProperty("HTML_CODE");
        if (html == null || html.isEmpty()) {
            this.textArea.setText(DEFAULT_HTML);
        } else {
            this.textArea.setText(html);
        }
    }

    public void show() {
        super.show();
    }

    public void hide() {
        super.hide();
    }

    protected void addHiddenHandler() {
        this.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent hiddenEvent) {
                if (EditHTML.this.userPressedCloseOrCancel()) {
                    EditHTML.this.configContext.configurationCancelled();
                }
            }
        });
    }

    private boolean userPressedCloseOrCancel() {
        return ButtonPressed.CANCEL.equals((Object)this.buttonPressed) || ButtonPressed.CLOSE.equals((Object)this.buttonPressed);
    }

    void cancelButton() {
        this.buttonPressed = ButtonPressed.CANCEL;
        this.hide();
    }

    void okButton() {
        this.buttonPressed = ButtonPressed.OK;
        this.hide();
        this.configContext.setComponentProperty("HTML_CODE", this.textArea.getText());
        this.configContext.configurationFinished();
    }

    protected ModalConfigurationContext getConfigContext() {
        return this.configContext;
    }

    static interface Binder
    extends UiBinder<Widget, EditHTML> {
    }

    public static interface Listener {
        public void onSave();

        public void onClose();
    }
}

