/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.split;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.plugin.client.widget.split.Splitter;
import org.uberfire.mvp.Command;

public class VerticalSplit
extends Splitter {
    private double offset;
    private Widget rightArea;
    private Widget leftArea;
    private Widget contentArea;
    private Command onResize;

    public VerticalSplit() {
        this.addDomHandler((EventHandler)new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (VerticalSplit.this.mouseDown) {
                    double leftWidthPct = ((double)(event.getClientX() - VerticalSplit.this.getContentAbsoluteLeft()) - VerticalSplit.this.offset) / (double)VerticalSplit.this.getContentWidth() * 100.0;
                    double rightWidthPct = 100.0 - leftWidthPct;
                    VerticalSplit.this.setLeftAreaWidth(leftWidthPct);
                    VerticalSplit.this.setRightAreaWidth(rightWidthPct);
                    VerticalSplit.this.getElement().getStyle().setLeft((double)(VerticalSplit.this.leftArea.getOffsetWidth() - 3), Style.Unit.PX);
                    VerticalSplit.this.onResize.execute();
                    event.preventDefault();
                }
            }
        }, MouseMoveEvent.getType());
    }

    @Override
    protected void buildOffset(MouseDownEvent event) {
        this.offset = event.getClientX() - this.getAbsoluteLeft();
    }

    public void init(Widget leftArea, Widget rightArea, Widget contentArea, Command onResize) {
        this.leftArea = leftArea;
        this.rightArea = rightArea;
        this.contentArea = contentArea;
        this.onResize = onResize;
    }

    private void setRightAreaWidth(double width) {
        this.rightArea.setWidth(width + "%");
    }

    private void setLeftAreaWidth(double width) {
        this.leftArea.setWidth(width + "%");
    }

    private int getContentWidth() {
        return this.contentArea.getOffsetWidth();
    }

    private int getContentAbsoluteLeft() {
        return this.contentArea.getAbsoluteLeft();
    }
}

