/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client;

import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.dom.client.StyleInjector;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBar;
import org.uberfire.ext.plugin.client.resources.WebAppResource;
import org.uberfire.ext.plugin.model.DynamicMenu;
import org.uberfire.ext.plugin.model.DynamicMenuItem;
import org.uberfire.ext.plugin.model.RuntimePlugin;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;

@EntryPoint
public class RuntimePluginsEntryPoint {
    @Inject
    private Workbench workbench;
    @Inject
    private Caller<PluginServices> pluginServices;
    @Inject
    private ClientMessageBus bus;
    @Inject
    private WorkbenchMenuBar menubar;
    @Inject
    private PlaceManager placeManager;

    @PostConstruct
    public void init() {
        WebAppResource.INSTANCE.CSS().ensureInjected();
        this.workbench.addStartupBlocker(RuntimePluginsEntryPoint.class);
    }

    @AfterInitialization
    public void setup() {
        ((PluginServices)this.pluginServices.call((RemoteCallback)new RemoteCallback<Collection<RuntimePlugin>>(){

            public void callback(Collection<RuntimePlugin> response) {
                for (RuntimePlugin plugin : response) {
                    ScriptInjector.fromString((String)plugin.getScript()).setWindow(ScriptInjector.TOP_WINDOW).inject();
                    StyleInjector.inject((String)plugin.getStyle(), (boolean)true);
                }
                ((PluginServices)RuntimePluginsEntryPoint.this.pluginServices.call((RemoteCallback)new RemoteCallback<Collection<DynamicMenu>>(){

                    public void callback(Collection<DynamicMenu> response) {
                        for (DynamicMenu menu : response) {
                            if (menu.getMenuItems().isEmpty()) continue;
                            MenuFactory.SubMenusBuilder dynamicMenu = ((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)menu.getName()).orderAll(100)).menus();
                            for (final DynamicMenuItem dynamicMenuItem : menu.getMenuItems()) {
                                ((MenuFactory.MenuBuilder)dynamicMenu.menu(dynamicMenuItem.getMenuLabel()).respondsWith(new Command(){

                                    public void execute() {
                                        RuntimePluginsEntryPoint.this.placeManager.goTo(dynamicMenuItem.getActivityId());
                                    }
                                })).endMenu();
                            }
                            RuntimePluginsEntryPoint.this.menubar.addMenus(((MenuFactory.TopLevelMenusBuilder)((MenuFactory.SubMenuBuilder)dynamicMenu.endMenus()).endMenu()).build());
                        }
                        RuntimePluginsEntryPoint.this.workbench.removeStartupBlocker(RuntimePluginsEntryPoint.class);
                    }
                })).listDynamicMenus();
            }
        })).listRuntimePlugins();
    }
}

