/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.popup;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.plugin.client.validation.NameValidator;
import org.uberfire.ext.plugin.client.validation.PluginNameValidator;
import org.uberfire.ext.plugin.client.validation.RuleValidator;
import org.uberfire.ext.plugin.client.widget.popup.NewPluginPopUpView;
import org.uberfire.ext.plugin.exception.PluginAlreadyExists;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@ApplicationScoped
public class NewPluginPopUp
implements NewPluginPopUpView.Presenter {
    @Inject
    Caller<PluginServices> pluginServices;
    @Inject
    PlaceManager placeManager;
    @Inject
    PluginNameValidator pluginNameValidator;
    private NewPluginPopUpView view;

    protected NewPluginPopUp() {
    }

    @Inject
    public NewPluginPopUp(NewPluginPopUpView view) {
        this.view = view;
        this.view.init(this);
    }

    @Override
    public RuleValidator getNameValidator() {
        return NameValidator.createNameValidator(this.view.emptyName(), this.view.invalidName());
    }

    @Override
    public void onOK(final String name, final PluginType type) {
        this.pluginNameValidator.validate(name + ".plugin", (ValidatorCallback)new ValidatorWithReasonCallback(){

            public void onFailure(String reason) {
                if (ValidationErrorReason.EMPTY_NAME.name().equals(reason)) {
                    NewPluginPopUp.this.view.handleNameValidationError(NewPluginPopUp.this.view.emptyName());
                } else if (ValidationErrorReason.DUPLICATED_NAME.name().equals(reason)) {
                    NewPluginPopUp.this.view.handleNameValidationError(NewPluginPopUp.this.view.duplicatedName());
                } else {
                    NewPluginPopUp.this.view.handleNameValidationError(NewPluginPopUp.this.view.invalidName());
                }
            }

            public void onSuccess() {
                ((PluginServices)NewPluginPopUp.this.pluginServices.call((RemoteCallback)new RemoteCallback<Plugin>(){

                    public void callback(Plugin response) {
                        NewPluginPopUp.this.placeManager.goTo(NewPluginPopUp.this.getPathPlaceRequest(response));
                        NewPluginPopUp.this.hide();
                    }
                }, (ErrorCallback)new ErrorCallback<Object>(){

                    public boolean error(Object message, Throwable throwable) {
                        if (throwable instanceof PluginAlreadyExists) {
                            NewPluginPopUp.this.view.handleNameValidationError(NewPluginPopUp.this.view.duplicatedName());
                        } else {
                            NewPluginPopUp.this.view.handleNameValidationError(NewPluginPopUp.this.view.invalidName());
                        }
                        return false;
                    }
                })).createNewPlugin(name, type);
            }

            public void onFailure() {
                NewPluginPopUp.this.view.handleNameValidationError(NewPluginPopUp.this.view.invalidName());
            }
        });
    }

    protected PlaceRequest getPathPlaceRequest(Plugin response) {
        return new PathPlaceRequest(response.getPath()).addParameter("name", response.getName());
    }

    @Override
    public void onCancel() {
        this.hide();
    }

    public void show(PluginType type) {
        this.view.show(type);
    }

    private void hide() {
        this.view.hide();
    }
}

