/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.editor;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.uberfire.ext.editor.commons.client.BaseEditorViewImpl;
import org.uberfire.ext.plugin.client.editor.DynamicMenuEditorPresenter;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.plugin.client.widget.cell.IconCell;
import org.uberfire.ext.plugin.model.DynamicMenuItem;

@Dependent
public class DynamicMenuEditorView
extends BaseEditorViewImpl
implements DynamicMenuEditorPresenter.View,
Editor<DynamicMenuItem> {
    private static final ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private final Driver driver = (Driver)GWT.create(Driver.class);
    private final ProvidesKey<DynamicMenuItem> keyProvider = new ProvidesKey<DynamicMenuItem>(){

        public Object getKey(DynamicMenuItem item) {
            return item.getActivityId() + item.getMenuLabel();
        }
    };
    private final SingleSelectionModel<DynamicMenuItem> selectionModel = new SingleSelectionModel(this.keyProvider);
    @UiField
    TextBox activityId;
    @UiField
    FormGroup activityIdControlGroup;
    @UiField
    @Editor.Ignore
    HelpBlock activityIdHelpInline;
    @UiField
    TextBox menuLabel;
    @UiField
    FormGroup menuLabelControlGroup;
    @UiField
    @Editor.Ignore
    HelpBlock menuLabelHelpInline;
    @UiField(provided=true)
    CellTable<DynamicMenuItem> menuItems = new CellTable(500, (CellTable.Resources)GWT.create(CellTable.Resources.class), this.keyProvider, null);
    @UiField
    Button okButton;
    @UiField
    Button cancelButton;
    private DynamicMenuEditorPresenter presenter;
    private DynamicMenuItem editedItem;

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.editedItem = null;
    }

    public void init(DynamicMenuEditorPresenter presenter) {
        this.presenter = presenter;
        this.driver.initialize(this);
        this.setMenuItem(new DynamicMenuItem());
        this.initTable((AbstractCellTable<DynamicMenuItem>)this.menuItems);
    }

    private void initTable(AbstractCellTable<DynamicMenuItem> dynamicMenuTable) {
        dynamicMenuTable.setEmptyTableWidget((Widget)new Label(CommonConstants.INSTANCE.MenusNoMenuItems()));
        DefaultSelectionEventManager manager = DefaultSelectionEventManager.createBlacklistManager((int[])new int[]{4});
        dynamicMenuTable.setSelectionModel(this.selectionModel, (CellPreviewEvent.Handler)manager);
        dynamicMenuTable.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED);
        IconCell iCell = new IconCell(IconType.ARROW_UP);
        iCell.setTooltip(CommonConstants.INSTANCE.MenusMoveUpHint());
        Column iconColumn = new Column<DynamicMenuItem, String>((Cell)iCell){

            public String getValue(DynamicMenuItem object) {
                return "";
            }
        };
        iconColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<DynamicMenuItem, String>(){

            public void update(int index, DynamicMenuItem object, String value) {
                DynamicMenuEditorView.this.presenter.updateIndex(object, index, DynamicMenuEditorPresenter.UpdateIndexOperation.UP);
            }
        });
        dynamicMenuTable.addColumn(iconColumn);
        dynamicMenuTable.setColumnWidth(iconColumn, "25px");
        iCell = new IconCell(IconType.ARROW_DOWN);
        iCell.setTooltip(CommonConstants.INSTANCE.MenusMoveDownHint());
        iconColumn = new Column<DynamicMenuItem, String>((Cell)iCell){

            public String getValue(DynamicMenuItem object) {
                return "";
            }
        };
        iconColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<DynamicMenuItem, String>(){

            public void update(int index, DynamicMenuItem object, String value) {
                DynamicMenuEditorView.this.presenter.updateIndex(object, index, DynamicMenuEditorPresenter.UpdateIndexOperation.DOWN);
            }
        });
        dynamicMenuTable.addColumn(iconColumn);
        dynamicMenuTable.setColumnWidth(iconColumn, "25px");
        TextColumn<DynamicMenuItem> activityCol = new TextColumn<DynamicMenuItem>(){

            public String getValue(DynamicMenuItem object) {
                return String.valueOf(object.getActivityId());
            }
        };
        dynamicMenuTable.addColumn((Column)activityCol, CommonConstants.INSTANCE.MenusActivityID());
        TextColumn<DynamicMenuItem> labelCol = new TextColumn<DynamicMenuItem>(){

            public String getValue(DynamicMenuItem object) {
                return object.getMenuLabel();
            }
        };
        dynamicMenuTable.addColumn((Column)labelCol, CommonConstants.INSTANCE.MenusLabel());
        ButtonCell buttonCell = new ButtonCell(IconType.REMOVE, ButtonType.DANGER, ButtonSize.EXTRA_SMALL);
        Column<DynamicMenuItem, String> buttonCol = new Column<DynamicMenuItem, String>((Cell)buttonCell){

            public String getValue(DynamicMenuItem object) {
                return CommonConstants.INSTANCE.MenusDelete();
            }
        };
        buttonCol.setFieldUpdater((FieldUpdater)new FieldUpdater<DynamicMenuItem, String>(){

            public void update(int index, DynamicMenuItem object, String value) {
                if (DynamicMenuEditorView.this.selectionModel.isSelected((Object)object)) {
                    DynamicMenuEditorView.this.selectionModel.clear();
                }
                DynamicMenuEditorView.this.presenter.removeObject(object);
            }
        });
        dynamicMenuTable.addColumn((Column)buttonCol);
        dynamicMenuTable.setColumnWidth((Column)buttonCol, "80px");
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                if (DynamicMenuEditorView.this.selectionModel.getSelectedObject() == null) {
                    DynamicMenuEditorView.this.editedItem = null;
                    DynamicMenuEditorView.this.setMenuItem(new DynamicMenuItem());
                } else {
                    DynamicMenuEditorView.this.editedItem = (DynamicMenuItem)DynamicMenuEditorView.this.selectionModel.getSelectedObject();
                    DynamicMenuEditorView.this.setMenuItem(new DynamicMenuItem(((DynamicMenuItem)DynamicMenuEditorView.this.selectionModel.getSelectedObject()).getActivityId(), ((DynamicMenuItem)DynamicMenuEditorView.this.selectionModel.getSelectedObject()).getMenuLabel()));
                }
            }
        });
        this.presenter.setDataDisplay((HasData<DynamicMenuItem>)dynamicMenuTable);
    }

    @UiHandler(value={"okButton"})
    public void onClick(ClickEvent e) {
        DynamicMenuItem menuItem = (DynamicMenuItem)this.driver.flush();
        if (this.isMenuItemValid(menuItem)) {
            if (this.editedItem != null) {
                this.editedItem.setActivityId(menuItem.getActivityId());
                this.editedItem.setMenuLabel(menuItem.getMenuLabel());
                menuItem = this.editedItem;
            }
            this.presenter.addMenuItem(menuItem);
            this.setMenuItem(new DynamicMenuItem());
            this.selectionModel.clear();
        }
    }

    @UiHandler(value={"cancelButton"})
    public void onCancel(ClickEvent e) {
        this.setMenuItem(new DynamicMenuItem());
        this.selectionModel.clear();
    }

    private boolean isMenuItemValid(DynamicMenuItem menuItem) {
        boolean activityIdValidatorResult = this.presenter.getMenuItemActivityIdValidator().validateFieldInline(menuItem.getActivityId(), this.activityIdControlGroup, this.activityIdHelpInline);
        boolean menuLabelValidatorResult = this.presenter.getMenuItemLabelValidator(menuItem, this.editedItem).validateFieldInline(menuItem.getMenuLabel(), this.menuLabelControlGroup, this.menuLabelHelpInline);
        return activityIdValidatorResult && menuLabelValidatorResult;
    }

    public void setMenuItem(DynamicMenuItem menuItem) {
        this.driver.edit(menuItem);
        this.activityIdControlGroup.setValidationState(ValidationState.NONE);
        this.activityIdHelpInline.setText("");
        this.menuLabelControlGroup.setValidationState(ValidationState.NONE);
        this.menuLabelHelpInline.setText("");
    }

    @Override
    public String emptyActivityID() {
        return CommonConstants.INSTANCE.EmptyActivityID();
    }

    @Override
    public String invalidActivityID() {
        return CommonConstants.INSTANCE.InvalidActivityID();
    }

    @Override
    public String emptyMenuLabel() {
        return CommonConstants.INSTANCE.EmptyMenuLabel();
    }

    @Override
    public String invalidMenuLabel() {
        return CommonConstants.INSTANCE.InvalidMenuLabel();
    }

    @Override
    public String duplicatedMenuLabel() {
        return CommonConstants.INSTANCE.DuplicatedMenuLabel();
    }

    static interface Driver
    extends SimpleBeanEditorDriver<DynamicMenuItem, DynamicMenuEditorView> {
    }

    static interface ViewBinder
    extends UiBinder<Widget, DynamicMenuEditorView> {
    }
}

