/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Modal;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlEditorPresenter;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;

@Dependent
public class EditHTMLPresenter {
    private View view;
    private ModalConfigurationContext modalConfigurationContext;
    private HtmlEditorPresenter htmlEditor;

    @Inject
    public EditHTMLPresenter(View view, HtmlEditorPresenter htmlEditor) {
        this.view = view;
        this.htmlEditor = htmlEditor;
    }

    public void init(ModalConfigurationContext modalConfigurationContext) {
        this.modalConfigurationContext = modalConfigurationContext;
        this.setupHTMLEditor();
        this.view.init(this);
    }

    public void show() {
        this.view.show();
    }

    void setupHTMLEditor() {
        String html = this.modalConfigurationContext.getComponentProperty("HTML_CODE");
        if (html == null || html.isEmpty()) {
            html = this.view.getHtmlEditorPlaceHolder();
        }
        this.htmlEditor.setContent(html);
        this.htmlEditor.load();
    }

    void closeClick() {
        this.modalConfigurationContext.configurationCancelled();
    }

    void cancelClick() {
        this.view.hide();
        this.modalConfigurationContext.configurationCancelled();
    }

    void okClick() {
        this.view.hide();
        this.modalConfigurationContext.setComponentProperty("HTML_CODE", this.htmlEditor.getContent());
        this.modalConfigurationContext.configurationFinished();
    }

    public HtmlEditorPresenter.View getHtmlEditorView() {
        return this.htmlEditor.getView();
    }

    public ModalConfigurationContext getModalConfigurationContext() {
        return this.modalConfigurationContext;
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<EditHTMLPresenter> {
        public void show();

        public void hide();

        public String getHtmlEditorPlaceHolder();

        public Modal getModal();
    }
}

