/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.commons.data.Cacheable;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.RuntimeFeatureResource;
import org.uberfire.security.impl.authz.RuntimeAuthorizationManager;

public class RuntimeAuthorizationManagerTest {
    @Test
    public void testAuthorizeWithCacheRefreshOnRemoveAllRoles() {
        RuntimeAuthorizationManager authorizationManager = new RuntimeAuthorizationManager();
        TestRuntimeResource resource = new TestRuntimeResource("test1234", "author");
        UserImpl john = new UserImpl("john", (Collection)ImmutableSet.of((Object)new RoleImpl("admin")));
        UserImpl mary = new UserImpl("mary", (Collection)ImmutableSet.of((Object)new RoleImpl("author")));
        Assert.assertTrue((boolean)(resource instanceof Cacheable));
        Assert.assertTrue((boolean)((Cacheable)resource).requiresRefresh());
        boolean authorized = authorizationManager.authorize((Resource)resource, (User)john);
        Assert.assertFalse((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource, (User)mary);
        Assert.assertTrue((boolean)authorized);
        TestRuntimeResource resource2 = new TestRuntimeResource("test1234", null);
        Assert.assertTrue((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (User)john);
        Assert.assertTrue((boolean)authorized);
        authorized = authorizationManager.authorize((Resource)resource2, (User)mary);
        Assert.assertTrue((boolean)authorized);
    }

    @Test
    public void testAuthorizeWithCacheRefreshOnAddedRole() {
        RuntimeAuthorizationManager authorizationManager = new RuntimeAuthorizationManager();
        TestRuntimeResource resource = new TestRuntimeResource("test1234", "author");
        UserImpl john = new UserImpl("john", (Collection)ImmutableSet.of((Object)new RoleImpl("admin")));
        UserImpl mary = new UserImpl("mary", (Collection)ImmutableSet.of((Object)new RoleImpl("author")));
        Assert.assertTrue((boolean)(resource instanceof Cacheable));
        Assert.assertTrue((boolean)((Cacheable)resource).requiresRefresh());
        boolean authorized = authorizationManager.authorize((Resource)resource, (User)john);
        Assert.assertFalse((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource, (User)mary);
        Assert.assertTrue((boolean)authorized);
        TestRuntimeResource resource2 = new TestRuntimeResource("test1234", "admin", "author");
        Assert.assertTrue((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (User)john);
        Assert.assertTrue((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (User)mary);
        Assert.assertTrue((boolean)authorized);
    }

    @Test
    public void testAuthorizeWithCacheRefreshOnRemovedRole() {
        RuntimeAuthorizationManager authorizationManager = new RuntimeAuthorizationManager();
        TestRuntimeResource resource = new TestRuntimeResource("test1234", "admin", "author");
        UserImpl john = new UserImpl("john", (Collection)ImmutableSet.of((Object)new RoleImpl("admin")));
        UserImpl mary = new UserImpl("mary", (Collection)ImmutableSet.of((Object)new RoleImpl("author")));
        Assert.assertTrue((boolean)(resource instanceof Cacheable));
        Assert.assertTrue((boolean)((Cacheable)resource).requiresRefresh());
        boolean authorized = authorizationManager.authorize((Resource)resource, (User)john);
        Assert.assertTrue((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource, (User)mary);
        Assert.assertTrue((boolean)authorized);
        TestRuntimeResource resource2 = new TestRuntimeResource("test1234", "author");
        Assert.assertTrue((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (User)john);
        Assert.assertFalse((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (User)mary);
        Assert.assertTrue((boolean)authorized);
    }

    private class TestRuntimeResource
    implements RuntimeFeatureResource,
    Cacheable {
        private final String signatureId;
        private List<String> roles;
        private boolean requiresRefresh = true;

        protected TestRuntimeResource(String signatureId, String ... roles) {
            this.signatureId = signatureId;
            this.roles = roles != null ? Arrays.asList(roles) : Collections.emptyList();
        }

        public String getSignatureId() {
            return this.signatureId;
        }

        public Collection<String> getRoles() {
            return this.roles;
        }

        public Collection<String> getTraits() {
            return Collections.emptySet();
        }

        public void markAsCached() {
            this.requiresRefresh = false;
        }

        public boolean requiresRefresh() {
            return this.requiresRefresh;
        }
    }
}

