/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.impl.authz.DefaultPermissionCollection;
import org.uberfire.security.impl.authz.DotNamedPermission;

public class PermissionCollectionTest {
    Permission p1 = new DotNamedPermission("resource.read");
    Permission p2 = new DotNamedPermission("resource.read", Boolean.valueOf(true));
    Permission p3 = new DotNamedPermission("resource.read", Boolean.valueOf(false));
    Permission p4 = new DotNamedPermission("resource.read.id1", Boolean.valueOf(true));
    Permission p5 = new DotNamedPermission("resource.read.id1", Boolean.valueOf(false));
    Permission p6 = new DotNamedPermission("resource.read.id2", Boolean.valueOf(true));
    Permission p7 = new DotNamedPermission("resource.read.id2", Boolean.valueOf(false));
    Permission p8 = new DotNamedPermission("perspective.read.id1", Boolean.valueOf(true));

    @Test
    public void testNotAdded() {
        DefaultPermissionCollection pc = new DefaultPermissionCollection();
        pc.add(new Permission[]{new DotNamedPermission("resource.read", Boolean.valueOf(true))});
        pc.add(new Permission[]{new DotNamedPermission("resource.read.id1")});
        pc.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(true))});
        pc.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(false))});
        Assert.assertEquals((long)pc.collection().size(), (long)2L);
    }

    @Test
    public void testEmpty() {
        DefaultPermissionCollection pc = new DefaultPermissionCollection();
        Assert.assertFalse((boolean)pc.implies(this.p1));
        Assert.assertFalse((boolean)pc.implies(this.p2));
        Assert.assertFalse((boolean)pc.implies(this.p3));
    }

    @Test
    public void testGranted() {
        DefaultPermissionCollection pc = new DefaultPermissionCollection();
        pc.add(new Permission[]{new DotNamedPermission("resource.read", Boolean.valueOf(true))});
        Assert.assertTrue((boolean)pc.implies(this.p1));
        Assert.assertTrue((boolean)pc.implies(this.p2));
        Assert.assertFalse((boolean)pc.implies(this.p3));
    }

    @Test
    public void testAbstain() {
        DefaultPermissionCollection pc = new DefaultPermissionCollection();
        pc.add(new Permission[]{new DotNamedPermission("resource.read")});
        Assert.assertTrue((boolean)pc.implies(this.p1));
        Assert.assertFalse((boolean)pc.implies(this.p2));
        Assert.assertFalse((boolean)pc.implies(this.p3));
    }

    @Test
    public void testDenied() {
        DefaultPermissionCollection pc = new DefaultPermissionCollection();
        pc.add(new Permission[]{new DotNamedPermission("resource.read", Boolean.valueOf(false))});
        Assert.assertFalse((boolean)pc.implies(this.p1));
        Assert.assertFalse((boolean)pc.implies(this.p2));
        Assert.assertTrue((boolean)pc.implies(this.p3));
    }

    @Test
    public void testChildGranted() {
        DefaultPermissionCollection pc = new DefaultPermissionCollection();
        pc.add(new Permission[]{new DotNamedPermission("", Boolean.valueOf(false))});
        pc.add(new Permission[]{new DotNamedPermission("resource.read", Boolean.valueOf(false))});
        pc.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(true))});
        Assert.assertTrue((boolean)pc.implies(this.p4));
        Assert.assertTrue((boolean)pc.implies(this.p5));
        Assert.assertFalse((boolean)pc.implies(this.p6));
        Assert.assertTrue((boolean)pc.implies(this.p7));
    }

    @Test
    public void testChildDenied() {
        DefaultPermissionCollection pc = new DefaultPermissionCollection();
        pc.add(new Permission[]{new DotNamedPermission("", Boolean.valueOf(true))});
        pc.add(new Permission[]{new DotNamedPermission("resource.read", Boolean.valueOf(true))});
        pc.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(false))});
        Assert.assertTrue((boolean)pc.implies(this.p4));
        Assert.assertTrue((boolean)pc.implies(this.p5));
        Assert.assertTrue((boolean)pc.implies(this.p6));
        Assert.assertFalse((boolean)pc.implies(this.p7));
    }

    @Test
    public void testOtherAbstain() {
        DefaultPermissionCollection pc = new DefaultPermissionCollection();
        pc.add(new Permission[]{new DotNamedPermission("resource.read", Boolean.valueOf(true))});
        pc.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(false))});
        Assert.assertFalse((boolean)pc.implies(this.p8));
    }

    @Test
    public void testMergeNull() {
        DefaultPermissionCollection pc1 = new DefaultPermissionCollection();
        PermissionCollection pc2 = null;
        PermissionCollection result = pc1.merge(pc2, 0);
        Assert.assertSame((Object)result, (Object)pc1);
    }

    @Test
    public void testMergeNoConflict() {
        DefaultPermissionCollection pc1 = new DefaultPermissionCollection();
        pc1.add(new Permission[]{new DotNamedPermission("resource.read", Boolean.valueOf(true))});
        pc1.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(false))});
        DefaultPermissionCollection pc2 = new DefaultPermissionCollection();
        pc2.add(new Permission[]{new DotNamedPermission("resource.read.id2", Boolean.valueOf(false))});
        PermissionCollection result = pc1.merge((PermissionCollection)pc2, 0);
        Assert.assertEquals((long)result.collection().size(), (long)2L);
        Assert.assertEquals((Object)result.get("resource.read").getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)result.get("resource.read.id1").getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertNull((Object)result.get("resource.read.id2"));
    }

    @Test
    public void testMergeGrantWinsByDefault() {
        DefaultPermissionCollection pc1 = new DefaultPermissionCollection();
        pc1.add(new Permission[]{new DotNamedPermission("resource.read", Boolean.valueOf(true))});
        pc1.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(false))});
        DefaultPermissionCollection pc2 = new DefaultPermissionCollection();
        pc2.add(new Permission[]{new DotNamedPermission("resource.read", Boolean.valueOf(true))});
        PermissionCollection result = pc1.merge((PermissionCollection)pc2, 0);
        Assert.assertEquals((long)result.collection().size(), (long)1L);
        Assert.assertEquals((Object)result.get("resource.read").getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testMergePriorityWins() {
        DefaultPermissionCollection pc1 = new DefaultPermissionCollection();
        pc1.add(new Permission[]{new DotNamedPermission("resource.read", Boolean.valueOf(true))});
        pc1.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(false))});
        DefaultPermissionCollection pc2 = new DefaultPermissionCollection();
        pc2.add(new Permission[]{new DotNamedPermission("resource.read", Boolean.valueOf(true))});
        PermissionCollection result = pc1.merge((PermissionCollection)pc2, -1);
        Assert.assertEquals((long)result.collection().size(), (long)2L);
        Assert.assertEquals((Object)result.get("resource.read").getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)result.get("resource.read.id1").getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        result = pc1.merge((PermissionCollection)pc2, 1);
        Assert.assertEquals((long)result.collection().size(), (long)1L);
        Assert.assertEquals((Object)result.get("resource.read").getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertNull((Object)result.get("resource.read.id1"));
    }

    @Test
    public void testMergeGrantedWins() {
        DefaultPermissionCollection pc1 = new DefaultPermissionCollection();
        pc1.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(false))});
        DefaultPermissionCollection pc2 = new DefaultPermissionCollection();
        pc2.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(true))});
        PermissionCollection result = pc1.merge((PermissionCollection)pc2, 0);
        Assert.assertEquals((long)result.collection().size(), (long)1L);
        Assert.assertEquals((Object)result.get("resource.read.id1").getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testMergeThisWins() {
        DefaultPermissionCollection pc1 = new DefaultPermissionCollection();
        pc1.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(false))});
        DefaultPermissionCollection pc2 = new DefaultPermissionCollection();
        pc2.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(true))});
        PermissionCollection result = pc1.merge((PermissionCollection)pc2, -1);
        Assert.assertEquals((long)result.collection().size(), (long)1L);
        Assert.assertEquals((Object)result.get("resource.read.id1").getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
    }

    @Test
    public void testMergeOtherWins() {
        DefaultPermissionCollection pc1 = new DefaultPermissionCollection();
        pc1.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(true))});
        DefaultPermissionCollection pc2 = new DefaultPermissionCollection();
        pc2.add(new Permission[]{new DotNamedPermission("resource.read.id1", Boolean.valueOf(false))});
        PermissionCollection result = pc1.merge((PermissionCollection)pc2, 1);
        Assert.assertEquals((long)result.collection().size(), (long)1L);
        Assert.assertEquals((Object)result.get("resource.read.id1").getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
    }
}

