/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.uberfire.security.authz.PermissionType;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.impl.authz.DotNamedPermissionType;

@ApplicationScoped
public class DefaultPermissionTypeRegistry
implements PermissionTypeRegistry {
    @Inject
    Instance<PermissionType> permissionTypeBeans;
    private Map<String, PermissionType> permissionTypes = new HashMap<String, PermissionType>();
    private PermissionType defaultPermissionType = new DotNamedPermissionType("");

    @PostConstruct
    private void init() {
        for (PermissionType permissionType : this.permissionTypeBeans) {
            this.register(permissionType);
        }
    }

    @Override
    public void register(PermissionType instance) {
        if (this.permissionTypes.containsKey(instance.getType())) {
            throw new IllegalStateException("PermissionType already exists: " + instance.getType());
        }
        this.permissionTypes.put(instance.getType(), instance);
    }

    @Override
    public PermissionType get(String type) {
        if (this.permissionTypes.containsKey(type)) {
            return this.permissionTypes.get(type);
        }
        return this.defaultPermissionType;
    }

    @Override
    public PermissionType resolve(String name) {
        for (PermissionType permissionType : this.permissionTypes.values()) {
            if (!permissionType.supportsPermission(name)) continue;
            return permissionType;
        }
        return this.defaultPermissionType;
    }
}

