/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.client.authz.tree.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTree;
import org.uberfire.security.client.authz.tree.PermissionTreeFactory;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.DefaultPermissionTree;

@ApplicationScoped
public class DefaultPermissionTreeFactory
implements PermissionTreeFactory {
    private PermissionManager permissionManager;
    private SyncBeanManager beanManager;
    private Collection<PermissionTreeProvider> permissionTreeProviderSet = new HashSet<PermissionTreeProvider>();

    public DefaultPermissionTreeFactory() {
    }

    @Inject
    public DefaultPermissionTreeFactory(PermissionManager permissionManager, SyncBeanManager beanManager) {
        this.permissionManager = permissionManager;
        this.beanManager = beanManager;
    }

    public DefaultPermissionTreeFactory(PermissionManager permissionManager, Collection<PermissionTreeProvider> permissionTreeProviderSet) {
        this.permissionManager = permissionManager;
        this.permissionTreeProviderSet = permissionTreeProviderSet;
    }

    @PostConstruct
    private void init() {
        for (SyncBeanDef beanDef : this.beanManager.lookupBeans(PermissionTreeProvider.class)) {
            PermissionTreeProvider provider = (PermissionTreeProvider)beanDef.getInstance();
            this.permissionTreeProviderSet.add(provider);
        }
    }

    @Override
    public PermissionTree createPermissionTree() {
        return this.createPermissionTree((PermissionCollection)null);
    }

    @Override
    public PermissionTree createPermissionTree(Role role) {
        AuthorizationPolicy policy = this.permissionManager.getAuthorizationPolicy();
        PermissionCollection pc = policy.getPermissions(role);
        return this.createPermissionTree(pc);
    }

    @Override
    public PermissionTree createPermissionTree(Group group) {
        AuthorizationPolicy policy = this.permissionManager.getAuthorizationPolicy();
        PermissionCollection pc = policy.getPermissions(group);
        return this.createPermissionTree(pc);
    }

    @Override
    public PermissionTree createPermissionTree(User user, VotingStrategy votingStrategy) {
        PermissionCollection pc = this.permissionManager.resolvePermissions(user, votingStrategy);
        return this.createPermissionTree(pc);
    }

    private PermissionTree createPermissionTree(PermissionCollection permissions) {
        ArrayList<PermissionNode> rootNodes = new ArrayList<PermissionNode>();
        for (PermissionTreeProvider provider : this.permissionTreeProviderSet) {
            PermissionNode rootNode;
            if (!provider.isActive() || (rootNode = provider.buildRootNode()) == null) continue;
            rootNodes.add(rootNode);
        }
        Collections.sort(rootNodes, this::compareRootNode);
        return new DefaultPermissionTree(this.permissionManager, rootNodes, permissions);
    }

    private int compareRootNode(PermissionNode n1, PermissionNode n2) {
        if (n1.getPositionInTree() > n2.getPositionInTree()) {
            return 1;
        }
        if (n1.getPositionInTree() < n2.getPositionInTree()) {
            return -1;
        }
        String name1 = n1.getNodeName();
        String name2 = n2.getNodeName();
        return name1.compareTo(name2);
    }
}

