/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.client.authz;

import org.jboss.errai.codegen.Context;
import org.jboss.errai.codegen.Statement;
import org.jboss.errai.ioc.rebind.ioc.injector.api.Decorable;
import org.jboss.errai.ioc.rebind.ioc.injector.api.FactoryController;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.security.annotations.ResourceCheck;
import org.uberfire.security.processors.ResourceCheckProcessor;

@RunWith(value=MockitoJUnitRunner.class)
public class ResourceCheckProcessorTest {
    @Mock
    Decorable decorable;
    @Mock
    FactoryController controller;
    Context context = Context.create();
    ResourceCheckProcessor processor;

    @Before
    public void setUp() {
        this.processor = new ResourceCheckProcessor(ResourceCheck.class);
        this.context.addVariable("project1", String.class);
        this.context.addVariable("this", FunctionTest.class);
    }

    @Test
    public void testGlobalActionStatement() {
        Statement stmt = this.processor.createGlobalActionCheck("project", "create", null, null);
        String ifStr = stmt.generate(this.context);
        Assert.assertEquals((Object)ifStr, (Object)"if (!(org.uberfire.security.client.authz.AuthorizationManagerHelper.authorize(\"project\", \"create\"))) {\n  return;\n}");
    }

    @Test
    public void testResourceActionStatement() {
        Statement stmt = this.processor.createResourceActionCheck("project1", "create", null, null);
        String ifStr = stmt.generate(this.context);
        Assert.assertEquals((Object)ifStr, (Object)"if (!(org.uberfire.security.client.authz.AuthorizationManagerHelper.authorize(project1, \"create\"))) {\n  return;\n}");
    }

    @Test
    public void testCallbacks() {
        Statement stmt = this.processor.createResourceActionCheck("project1", "read", "granted", "denied");
        String ifStr = stmt.generate(this.context);
        Assert.assertEquals((Object)ifStr, (Object)"if (!(org.uberfire.security.client.authz.AuthorizationManagerHelper.authorize(project1, \"read\"))) {\n  denied();\n  return;\n} else {\n  granted();\n}");
    }

    static interface FunctionTest {
        public void granted();

        public void denied();
    }
}

