/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadException;
import org.uberfire.io.IOService;
import org.uberfire.server.BaseUploadServlet;

public class FileUploadServlet
extends BaseUploadServlet {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (request.getParameter("path") != null) {
                this.writeFile(this.ioService, this.ioService.get(new URI(request.getParameter("path"))), this.getFileItem(request));
                this.writeResponse(response, "OK");
            } else if (request.getParameter("folder") != null) {
                this.writeFile(this.ioService, this.ioService.get(new URI(request.getParameter("folder") + "/" + request.getParameter("fileName"))), this.getFileItem(request));
                this.writeResponse(response, "OK");
            }
        }
        catch (FileUploadException e) {
            this.logError(e);
            this.writeResponse(response, "FAIL");
        }
        catch (URISyntaxException e) {
            this.logError(e);
            this.writeResponse(response, "FAIL");
        }
    }
}

