/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server.locale;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Scanner;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.server.locale.GWTLocaleHeaderFilter;

public class GWTLocaleHeaderFilterTest {
    @Test
    public void testLocaleDefault() throws IOException, ServletException {
        GWTLocaleHeaderFilter localeHeaderFilter = this.getFilter();
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        Mockito.when((Object)req.getLocale()).thenReturn((Object)Locale.US);
        Mockito.when((Object)resp.getOutputStream()).thenReturn((Object)new ServletOutputStream(){

            public void write(int b) throws IOException {
                baos.write(b);
            }
        });
        localeHeaderFilter.doFilter((ServletRequest)req, (ServletResponse)resp, chain);
        Assert.assertEquals((Object)new Scanner(this.getClass().getResourceAsStream("/expected-sample.html"), "UTF-8").useDelimiter("\\A").next(), (Object)baos.toString());
    }

    @Test
    public void testLocaleParameter() throws IOException, ServletException {
        GWTLocaleHeaderFilter localeHeaderFilter = this.getFilter();
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        Mockito.when((Object)req.getParameter("locale")).thenReturn((Object)"jp");
        Mockito.when((Object)resp.getOutputStream()).thenReturn((Object)new ServletOutputStream(){

            public void write(int b) throws IOException {
                baos.write(b);
            }
        });
        localeHeaderFilter.doFilter((ServletRequest)req, (ServletResponse)resp, chain);
        Assert.assertEquals((Object)new Scanner(this.getClass().getResourceAsStream("/expected-2-sample.html"), "UTF-8").useDelimiter("\\A").next(), (Object)baos.toString());
    }

    @Test
    public void testNonExistentLocaleParameter() throws IOException, ServletException {
        GWTLocaleHeaderFilter localeHeaderFilter = this.getFilter();
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        Mockito.when((Object)req.getParameter("locale")).thenReturn((Object)"xxx");
        Mockito.when((Object)req.getLocale()).thenReturn((Object)Locale.US);
        Mockito.when((Object)resp.getOutputStream()).thenReturn((Object)new ServletOutputStream(){

            public void write(int b) throws IOException {
                baos.write(b);
            }
        });
        localeHeaderFilter.doFilter((ServletRequest)req, (ServletResponse)resp, chain);
        Assert.assertEquals((Object)new Scanner(this.getClass().getResourceAsStream("/expected-3-sample.html"), "UTF-8").useDelimiter("\\A").next(), (Object)baos.toString());
    }

    private GWTLocaleHeaderFilter getFilter() {
        return new GWTLocaleHeaderFilter(){

            protected GWTLocaleHeaderFilter.CharResponseWrapper getWrapper(HttpServletResponse response) {
                GWTLocaleHeaderFilter.CharResponseWrapper wrapper = new GWTLocaleHeaderFilter.CharResponseWrapper(response);
                String text = new Scanner(((Object)((Object)this)).getClass().getResourceAsStream("/sample.html"), "UTF-8").useDelimiter("\\A").next();
                try {
                    wrapper.getOutputStream().write(text.getBytes());
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return wrapper;
            }
        };
    }
}

