/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server.locale;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Scanner;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.server.locale.GWTLocaleHeaderFilter;

public class GWTLocaleHeaderFilterTest {
    @Test
    public void testLocaleDefault() throws IOException, ServletException {
        GWTLocaleHeaderFilter localeHeaderFilter = this.getFilter();
        StringWriter sw = new StringWriter();
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        Mockito.when((Object)req.getLocale()).thenReturn((Object)Locale.US);
        Mockito.when((Object)resp.getWriter()).thenReturn((Object)new PrintWriter(sw));
        localeHeaderFilter.doFilter((ServletRequest)req, (ServletResponse)resp, chain);
        Assert.assertEquals((Object)new Scanner(this.getClass().getResourceAsStream("/expected-sample.html"), "UTF-8").useDelimiter("\\A").next(), (Object)((Object)sw).toString());
    }

    @Test
    public void testLocaleWithLanguageParameter() throws IOException, ServletException {
        GWTLocaleHeaderFilter localeHeaderFilter = this.getFilter();
        StringWriter sw = new StringWriter();
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        Mockito.when((Object)req.getParameter("locale")).thenReturn((Object)"ja");
        Mockito.when((Object)resp.getWriter()).thenReturn((Object)new PrintWriter(sw));
        localeHeaderFilter.doFilter((ServletRequest)req, (ServletResponse)resp, chain);
        Assert.assertEquals((Object)new Scanner(this.getClass().getResourceAsStream("/expected-2-sample.html"), "UTF-8").useDelimiter("\\A").next(), (Object)((Object)sw).toString());
    }

    @Test
    public void testLocaleWithLanguageAndCountryParameter() throws IOException, ServletException {
        GWTLocaleHeaderFilter localeHeaderFilter = this.getFilter();
        StringWriter sw = new StringWriter();
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        Mockito.when((Object)req.getParameter("locale")).thenReturn((Object)"ja_JP");
        Mockito.when((Object)resp.getWriter()).thenReturn((Object)new PrintWriter(sw));
        localeHeaderFilter.doFilter((ServletRequest)req, (ServletResponse)resp, chain);
        Assert.assertEquals((Object)new Scanner(this.getClass().getResourceAsStream("/expected-3-sample.html"), "UTF-8").useDelimiter("\\A").next(), (Object)((Object)sw).toString());
    }

    @Test
    public void testNonExistentLocaleParameter() throws IOException, ServletException {
        GWTLocaleHeaderFilter localeHeaderFilter = this.getFilter();
        StringWriter sw = new StringWriter();
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        Mockito.when((Object)req.getParameter("locale")).thenReturn((Object)"xxx");
        Mockito.when((Object)req.getLocale()).thenReturn((Object)Locale.US);
        Mockito.when((Object)resp.getWriter()).thenReturn((Object)new PrintWriter(sw));
        localeHeaderFilter.doFilter((ServletRequest)req, (ServletResponse)resp, chain);
        Assert.assertEquals((Object)new Scanner(this.getClass().getResourceAsStream("/expected-4-sample.html"), "UTF-8").useDelimiter("\\A").next(), (Object)((Object)sw).toString());
    }

    private GWTLocaleHeaderFilter getFilter() {
        return new GWTLocaleHeaderFilter(){

            protected GWTLocaleHeaderFilter.CharResponseWrapper getWrapper(HttpServletResponse response) {
                GWTLocaleHeaderFilter.CharResponseWrapper wrapper = new GWTLocaleHeaderFilter.CharResponseWrapper(response);
                String text = new Scanner(((Object)((Object)this)).getClass().getResourceAsStream("/sample.html"), "UTF-8").useDelimiter("\\A").next();
                try {
                    wrapper.getOutputStream().write(text.getBytes());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return wrapper;
            }
        };
    }
}

