/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import javax.enterprise.inject.Instance;
import org.jboss.errai.bus.client.api.QueueSession;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.bus.server.api.RpcContext;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.server.cdi.UberFireGeneralFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class UberFireGeneralFactoryTest {
    @Mock
    private Instance<User> userInstance;
    @Mock
    private AuthenticationService authService;
    @Mock
    private Message threadMessage;
    @Mock
    private QueueSession threadQueueSession;
    private User sessionUser = new UserImpl("session");
    private User defaultUser = new UserImpl("default");
    @InjectMocks
    private UberFireGeneralFactory factory;

    @Before
    public void setup() {
        Mockito.when((Object)this.authService.getUser()).thenThrow(new Throwable[]{new AssertionError((Object)"Should not call authentication service")});
        Mockito.when((Object)this.threadMessage.getResource(QueueSession.class, "Session")).thenReturn((Object)this.threadQueueSession);
        Mockito.when((Object)this.threadQueueSession.getSessionId()).thenReturn((Object)this.sessionUser.getIdentifier());
        RpcContext.set(null);
    }

    @Test
    public void returnDefaultUserOutsideOfSessionThread() throws Exception {
        Mockito.when((Object)this.userInstance.isAmbiguous()).thenReturn((Object)false);
        Mockito.when((Object)this.userInstance.isUnsatisfied()).thenReturn((Object)false);
        Mockito.when((Object)this.userInstance.get()).thenReturn((Object)this.defaultUser);
        SessionInfo sessionInfo = this.factory.getSessionInfo(this.authService);
        Assert.assertSame((Object)this.defaultUser, (Object)sessionInfo.getIdentity());
    }

    @Test
    public void returnAuthenticatedUserInSessionThread() throws Exception {
        Mockito.when((Object)this.userInstance.isAmbiguous()).thenReturn((Object)false);
        Mockito.when((Object)this.userInstance.isUnsatisfied()).thenReturn((Object)false);
        Mockito.when((Object)this.userInstance.get()).thenReturn((Object)this.defaultUser);
        Mockito.reset((Object[])new AuthenticationService[]{this.authService});
        Mockito.when((Object)this.authService.getUser()).thenReturn((Object)this.sessionUser);
        RpcContext.set((Message)this.threadMessage);
        SessionInfo sessionInfo = this.factory.getSessionInfo(this.authService);
        Assert.assertSame((Object)this.sessionUser, (Object)sessionInfo.getIdentity());
    }

    @Test(expected=IllegalStateException.class)
    public void throwIllegalStateExceptionOutsideOfSessionThreadWithoutDefaultUser() throws Exception {
        Mockito.when((Object)this.userInstance.isAmbiguous()).thenReturn((Object)false);
        Mockito.when((Object)this.userInstance.isUnsatisfied()).thenReturn((Object)true);
        Mockito.when((Object)this.userInstance.get()).thenReturn((Object)this.defaultUser);
        this.factory.getSessionInfo(this.authService);
    }
}

