/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.net.URI;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.server.FileDownloadServlet;
import org.uberfire.server.util.FileServletUtil;

@RunWith(value=MockitoJUnitRunner.class)
public class FileDownloadServletTest {
    private static final String PARAM_PATH = "path";
    private static final String TEST_ROOT_PATH = "default://master@test-repository/test-project/src/main/resources/test";
    private static final String TEST_ROOT_PATH_WITH_SPACES = "default://master@mtest-repository/my test project/src/main/resources/test";
    @Mock
    private IOService ioService;
    @Mock
    private ServletOutputStream servletOutputStream;
    @InjectMocks
    private FileDownloadServlet downloadServlet;

    @Test
    public void downloadByPathWithNoSpaces() throws Exception {
        String fileName = "FileNameWithNoSpaces.someextension";
        String fileContent = "the local file content";
        this.doDownloadByPath(TEST_ROOT_PATH, fileName, fileContent);
    }

    @Test
    public void downloadByPathWithSpaces() throws Exception {
        String fileName = "File Name With Spaces.some extension";
        String fileContent = "the local file content";
        this.doDownloadByPath(TEST_ROOT_PATH_WITH_SPACES, fileName, fileContent);
    }

    private void doDownloadByPath(String sourceFolder, String sourceFileName, String fileContent) throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        String sourcePath = sourceFolder + "/" + sourceFileName;
        Mockito.when((Object)request.getParameter(PARAM_PATH)).thenReturn((Object)sourcePath);
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)this.servletOutputStream);
        Path path = (Path)Mockito.mock(Path.class);
        Path pathFileName = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)pathFileName);
        Mockito.when((Object)pathFileName.toString()).thenReturn((Object)sourceFileName);
        URI expectedURI = new URI(FileServletUtil.encodeFileNamePart((String)sourcePath.replaceAll("\\s", "%20")));
        Mockito.when((Object)this.ioService.get(expectedURI)).thenReturn((Object)path);
        Mockito.when((Object)this.ioService.readAllBytes(path)).thenReturn((Object)fileContent.getBytes());
        this.downloadServlet.doGet(request, response);
        ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setHeader("Content-Disposition", String.format("attachment; filename=\"%s\";", sourceFileName));
        ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setContentType((String)Matchers.eq((Object)"application/octet-stream"));
        ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).getOutputStream();
        ((ServletOutputStream)Mockito.verify((Object)this.servletOutputStream, (VerificationMode)Mockito.times((int)1))).write(fileContent.getBytes(), 0, fileContent.getBytes().length);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).get((URI)Matchers.eq((Object)expectedURI));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).readAllBytes((Path)Matchers.eq((Object)path));
    }
}

