/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.server.FileUploadServlet;
import org.uberfire.server.util.FileServletUtil;

@RunWith(value=MockitoJUnitRunner.class)
public class FileUploadServletTest {
    private static final String PARAM_PATH = "path";
    private static final String PARAM_FOLDER = "folder";
    private static final String PARAM_FILENAME = "fileName";
    private static final String TEST_ROOT_PATH = "default://master@test-repository/test-project/src/main/resources/test";
    private static final String TEST_ROOT_PATH_WITH_SPACES = "default://master@mtest-repository/my test project/src/main/resources/test";
    private static final String BOUNDARY = "---------------------------9051914041544843365972754266";
    private static final String BOUNDARY_DELIMITER = "--";
    private static final String CONTENT_TYPE = "multipart/form-data; boundary=\"---------------------------9051914041544843365972754266\"";
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final String BREAK = new String(new char[]{'\r', '\n'});
    @Mock
    private IOService ioService;
    @Mock
    private Path path;
    @Mock
    private FileSystem fileSystem;
    @InjectMocks
    private FileUploadServlet uploadServlet;

    @Before
    public void setup() {
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)this.path);
        Mockito.when((Object)this.path.getFileSystem()).thenReturn((Object)this.fileSystem);
    }

    @Test
    public void uploadByNameWithSpacesAndFolder() throws Exception {
        String targetFileName = "File Name With Spaces.some extension";
        String fileContent = "the local file content";
        this.doUploadTestByNameAndFolder(targetFileName, TEST_ROOT_PATH, fileContent);
    }

    @Test
    public void uploadByNameAndFolderWithSpaces() throws Exception {
        String targetFileName = "File Name With Spaces.some extension";
        String fileContent = "the local file content";
        this.doUploadTestByNameAndFolder(targetFileName, TEST_ROOT_PATH_WITH_SPACES, fileContent);
    }

    @Test
    public void uploadByNameWithNoSpacesAndFolder() throws Exception {
        String targetFileName = "FileNameWithNoSpaces.someextension";
        String fileContent = "the local file content";
        this.doUploadTestByNameAndFolder(targetFileName, TEST_ROOT_PATH, fileContent);
    }

    @Test
    public void uploadByNameWithNoSpacesAndFolderWithSpaces() throws Exception {
        String targetFileName = "FileNameWithNoSpaces.someextension";
        String fileContent = "the local file content";
        this.doUploadTestByNameAndFolder(targetFileName, TEST_ROOT_PATH_WITH_SPACES, fileContent);
    }

    @Test
    public void uploadByPathWithSpacesAndFolderNoSpaces() throws Exception {
        String targetPath = "default://master@test-repository/test-project/src/main/resources/test/File Name With Spaces.some extension";
        String fileContent = "the local file content";
        this.doUploadTestByPath(targetPath, fileContent);
    }

    @Test
    public void uploadByPathWithSpacesAndFolderWithSpaces() throws Exception {
        String targetPathWithSpaces = TEST_ROOT_PATH_WITH_SPACES.replaceAll("\\s", "%20") + "/File Name With Spaces.some extension";
        String fileContent = "the local file content";
        this.doUploadTestByPath(targetPathWithSpaces, fileContent);
    }

    @Test
    public void uploadByPathWithNoSpacesAndFolderWithNoSpaces() throws Exception {
        String targetPath = TEST_ROOT_PATH.replaceAll("\\s", "%20") + "/FileNameWithNoSpaces.someextension";
        String fileContent = "the local file content";
        this.doUploadTestByPath(targetPath, fileContent);
    }

    @Test
    public void uploadByPathWithNoSpacesAndFolderWithSpaces() throws Exception {
        String targetPathWithSpaces = TEST_ROOT_PATH_WITH_SPACES.replaceAll("\\s", "%20") + "/FileNameWithNoSpaces.someextension";
        String fileContent = "the local file content";
        this.doUploadTestByPath(targetPathWithSpaces, fileContent);
    }

    private void doUploadTestByNameAndFolder(String targetFileName, String targetFolderName, String fileContent) throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        String localFileName = "local_file_name.txt";
        Mockito.when((Object)request.getParameter(PARAM_FOLDER)).thenReturn((Object)targetFolderName);
        Mockito.when((Object)request.getParameter(PARAM_FILENAME)).thenReturn((Object)targetFileName);
        String requestContent = this.mockMultipartRequestContent(localFileName, fileContent);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(requestContent.getBytes());
        MockServletInputStream servletInputStream = new MockServletInputStream(inputStream);
        Mockito.when((Object)request.getContentLength()).thenReturn((Object)requestContent.getBytes().length);
        Mockito.when((Object)request.getContentType()).thenReturn((Object)CONTENT_TYPE);
        Mockito.when((Object)request.getInputStream()).thenReturn((Object)servletInputStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)printWriter);
        this.uploadServlet.doPost(request, response);
        ((HttpServletRequest)Mockito.verify((Object)request, (VerificationMode)Mockito.times((int)1))).getParameter(PARAM_PATH);
        ((HttpServletRequest)Mockito.verify((Object)request, (VerificationMode)Mockito.times((int)2))).getParameter(PARAM_FOLDER);
        ((HttpServletRequest)Mockito.verify((Object)request, (VerificationMode)Mockito.times((int)1))).getParameter(PARAM_FILENAME);
        URI expectedURI = new URI(targetFolderName.replaceAll("\\s", "%20") + "/" + FileServletUtil.encodeFileName((String)targetFileName));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).startBatch((FileSystem)Mockito.eq((Object)this.fileSystem));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).get((URI)Mockito.eq((Object)expectedURI));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.any(Path.class), (byte[])Mockito.eq((Object)fileContent.getBytes()), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).endBatch();
        printWriter.flush();
        Assert.assertEquals((Object)"OK", (Object)new String(outputStream.toByteArray()));
    }

    private void doUploadTestByPath(String targetPath, String fileContent) throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        String localFileName = "local_file_name.txt";
        Mockito.when((Object)request.getParameter(PARAM_PATH)).thenReturn((Object)targetPath);
        String requestContent = this.mockMultipartRequestContent(localFileName, fileContent);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(requestContent.getBytes());
        MockServletInputStream servletInputStream = new MockServletInputStream(inputStream);
        Mockito.when((Object)request.getContentLength()).thenReturn((Object)requestContent.getBytes().length);
        Mockito.when((Object)request.getContentType()).thenReturn((Object)CONTENT_TYPE);
        Mockito.when((Object)request.getInputStream()).thenReturn((Object)servletInputStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)printWriter);
        this.uploadServlet.doPost(request, response);
        ((HttpServletRequest)Mockito.verify((Object)request, (VerificationMode)Mockito.times((int)2))).getParameter(PARAM_PATH);
        URI expectedURI = new URI(FileServletUtil.encodeFileNamePart((String)targetPath));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).startBatch((FileSystem)Mockito.eq((Object)this.fileSystem));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).get((URI)Mockito.eq((Object)expectedURI));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.any(Path.class), (byte[])Mockito.eq((Object)fileContent.getBytes()), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).endBatch();
        printWriter.flush();
        Assert.assertEquals((Object)"OK", (Object)new String(outputStream.toByteArray()));
    }

    private String mockMultipartRequestContent(String localFileName, String fileContent) {
        String content = "-----------------------------9051914041544843365972754266" + BREAK + "Content-Disposition: form-data; name=\"file\"; filename=\"" + localFileName + "\"" + BREAK + "Content-Type: text/plain" + BREAK + BREAK + fileContent + BREAK + BOUNDARY_DELIMITER + BOUNDARY + BOUNDARY_DELIMITER + BREAK;
        return content;
    }

    private class MockServletInputStream
    extends ServletInputStream {
        InputStream content;

        public MockServletInputStream(InputStream content) {
            this.content = content;
        }

        public int read() throws IOException {
            return this.content.read();
        }

        public int read(byte[] b) throws IOException {
            return this.content.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.content.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.content.skip(n);
        }

        public int available() throws IOException {
            return this.content.available();
        }

        public void close() throws IOException {
            this.content.close();
        }

        public synchronized void mark(int readlimit) {
            this.content.mark(readlimit);
        }

        public synchronized void reset() throws IOException {
            this.content.reset();
        }

        public boolean markSupported() {
            return this.content.markSupported();
        }

        public boolean isFinished() {
            try {
                return this.content.available() <= 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

