/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.guvnor.common.services.backend.preferences.ApplicationPreferencesLoader;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationPreferencesLoader
implements ApplicationPreferencesLoader {
    @Inject
    private ConfigurationService configurationService;
    private static final Logger log = LoggerFactory.getLogger(DefaultApplicationPreferencesLoader.class);

    public Map<String, String> load() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        List configs = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        for (ConfigGroup config : configs) {
            for (ConfigItem item : config.getItems()) {
                String name = item.getName();
                String value = config.getConfigItemValue(name);
                log.info("Setting preference '" + name + "' to '" + value + "'.");
                preferences.put(name, value);
            }
        }
        return preferences;
    }
}

