/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.uberfire.ext.security.server.RolesRegistry;
import org.uberfire.ext.security.server.SecurityIntegrationFilter;
import org.uberfire.ext.security.server.adapter.GroupsAdapter;

@Service
@ApplicationScoped
public class ServletSecurityAuthenticationService
implements AuthenticationService {
    private static final String USER_SESSION_ATTR_NAME = "uf.security.user";
    private static final String DEFAULT_ROLE_PRINCIPLE_NAME = "Roles";
    private final ServiceLoader<GroupsAdapter> groupsAdapterServiceLoader = ServiceLoader.load(GroupsAdapter.class);
    private String[] rolePrincipleNames = new String[]{"Roles"};

    public ServletSecurityAuthenticationService() {
        String value = System.getProperty("org.uberfire.security.principal.names", "");
        if (value != null && !value.trim().isEmpty()) {
            this.rolePrincipleNames = value.split(",");
        }
    }

    public User login(String username, String password) {
        HttpServletRequest request = ServletSecurityAuthenticationService.getRequestForThread();
        try {
            request.login(username, password);
            return this.getUser();
        }
        catch (ServletException e) {
            throw new FailedAuthenticationException();
        }
    }

    public boolean isLoggedIn() {
        HttpServletRequest request = ServletSecurityAuthenticationService.getRequestForThread();
        return request.getUserPrincipal() != null;
    }

    public void logout() {
        HttpServletRequest request = ServletSecurityAuthenticationService.getRequestForThread();
        try {
            request.logout();
        }
        catch (Exception e) {
            // empty catch block
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public User getUser() {
        HttpServletRequest request = ServletSecurityAuthenticationService.getRequestForThread();
        if (request.getUserPrincipal() == null) {
            return null;
        }
        User user = null;
        HttpSession session = request.getSession();
        if (session != null && (user = (User)session.getAttribute(USER_SESSION_ATTR_NAME)) == null) {
            HashSet<Role> userRoles = new HashSet<Role>();
            for (Role checkRole : RolesRegistry.get().getRegisteredRoles()) {
                if (!request.isUserInRole(checkRole.getName())) continue;
                userRoles.add(checkRole);
            }
            String name = request.getUserPrincipal().getName();
            HashSet<Group> userGroups = new HashSet<Group>(this.loadGroups());
            for (GroupsAdapter adapter : this.groupsAdapterServiceLoader) {
                List<Group> groupRoles = adapter.getGroups(name);
                if (groupRoles == null) continue;
                userGroups.addAll(groupRoles);
            }
            user = new UserImpl(name, userRoles, userGroups);
            session.setAttribute(USER_SESSION_ATTR_NAME, (Object)user);
        }
        return user;
    }

    private Set<Group> loadGroups() {
        Subject subject;
        try {
            subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (Exception e) {
            subject = null;
        }
        if (subject == null) {
            return Collections.emptySet();
        }
        HashSet<Group> result = new HashSet<Group>();
        Set<Principal> principals = subject.getPrincipals();
        if (principals != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                if (!(p instanceof java.security.acl.Group)) continue;
                for (String rolePrincipleName : this.rolePrincipleNames) {
                    if (!rolePrincipleName.equalsIgnoreCase(p.getName())) continue;
                    Enumeration groups = ((java.security.acl.Group)p).members();
                    while (groups.hasMoreElements()) {
                        Principal groupPrincipal = (Principal)groups.nextElement();
                        result.add((Group)new GroupImpl(groupPrincipal.getName()));
                    }
                }
            }
        }
        return result;
    }

    protected static HttpServletRequest getRequestForThread() {
        HttpServletRequest request = SecurityIntegrationFilter.getRequest();
        if (request == null) {
            throw new IllegalStateException("This service only works from threads that are handling HTTP servlet requests");
        }
        return request;
    }
}

